/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.automata;

import foundation.rpg.automata.LrItem;
import foundation.rpg.automata.LrItemSet;
import foundation.rpg.automata.LrParserAutomata;
import foundation.rpg.grammar.Grammar;
import foundation.rpg.grammar.Rule;
import foundation.rpg.grammar.Symbol;
import foundation.rpg.util.MapOfSets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LrParserConstructor {
    private final Grammar grammar;
    private final MapOfSets<Symbol, Symbol> first = new MapOfSets();
    private final Map<Symbol, Integer> counters = new LinkedHashMap<Symbol, Integer>();

    public LrParserConstructor(Grammar grammar) {
        this.grammar = grammar.augmented();
        this.countFirst();
    }

    private void countFirst() {
        this.grammar.getTerminals().forEach(symbol -> this.first.add((Symbol)symbol, (Symbol)symbol));
        while (this.addedFirstSymbol()) {
        }
    }

    private Set<Symbol> addedEpsilon(Rule rule) {
        LinkedHashSet<Symbol> symbols = new LinkedHashSet<Symbol>();
        for (Symbol s : rule.getRight()) {
            symbols.addAll(this.first.get(s));
            if (!symbols.contains(Symbol.\u03b5)) {
                return symbols;
            }
            symbols.remove(Symbol.\u03b5);
        }
        symbols.add(Symbol.\u03b5);
        return symbols;
    }

    private boolean addedFirstSymbol() {
        for (Symbol symbol : this.grammar.getNonTerminals()) {
            for (Rule rule : this.grammar.rulesFor(symbol)) {
                if (!this.first.add(symbol, this.addedEpsilon(rule))) continue;
                return true;
            }
        }
        return false;
    }

    public LrParserAutomata constructAutomata() {
        LinkedList<LrItemSet> processingSets = new LinkedList<LrItemSet>();
        LrItemSet start = this.closure(Symbol.any, this.grammar.rulesFor(this.grammar.getStart()).stream().map(rule -> LrItem.lrItem(rule, Collections.emptySet())).collect(Collectors.toSet()));
        LrParserAutomata parser = new LrParserAutomata(start, this.grammar);
        parser.addState(start);
        processingSets.add(start);
        while (!processingSets.isEmpty()) {
            LrItemSet set = (LrItemSet)processingSets.poll();
            MapOfSets transitions = new MapOfSets();
            set.getItems().forEach(lrItem -> {
                if (lrItem.isEnd()) {
                    if (lrItem.getLookahead().isEmpty()) {
                        parser.accept(set, (LrItem)lrItem);
                    } else {
                        lrItem.getLookahead().forEach(lookahead -> parser.reduction(set, (Symbol)lookahead, (LrItem)lrItem));
                    }
                } else {
                    transitions.add(lrItem.symbolAtDot(), lrItem.moveDot());
                }
            });
            transitions.forEach((transitionSymbol, baseSet) -> {
                LrItemSet nextSet = this.closure((Symbol)transitionSymbol, (Set<LrItem>)baseSet);
                if (parser.addState(nextSet)) {
                    processingSets.add(nextSet);
                }
                parser.transition(set, (Symbol)transitionSymbol, nextSet);
            });
        }
        return parser;
    }

    public LrItemSet closure(Symbol symbol, Set<LrItem> base) {
        ArrayDeque<LrItem> queue = new ArrayDeque<LrItem>(base);
        LinkedHashSet<LrItem> closure = new LinkedHashSet<LrItem>();
        while (!queue.isEmpty()) {
            LrItem item = (LrItem)queue.poll();
            if (!closure.add(item) || item.isEnd()) continue;
            this.grammar.rulesFor(item.symbolAtDot()).stream().map(rule -> LrItem.lrItem(rule, this.follow(item))).forEach(queue::add);
        }
        LinkedHashMap aggregator = new LinkedHashMap();
        closure.forEach(i -> aggregator.computeIfAbsent(i.getDot(), d -> new LinkedHashMap()).compute(i.getRule(), (r, t) -> {
            if (Objects.isNull(t)) {
                return i;
            }
            return i.mergeLookahead((LrItem)t);
        }));
        return new LrItemSet("" + symbol + this.counters.compute(symbol, (s, i) -> Objects.isNull(i) ? 1 : i + 1), aggregator.entrySet().stream().flatMap(e -> ((Map)e.getValue()).values().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public Set<Symbol> follow(LrItem item) {
        LinkedHashSet<Symbol> follow = new LinkedHashSet<Symbol>();
        for (int i = item.getDot() + 1; i < item.getRule().getRight().size(); ++i) {
            follow.addAll(this.first.get(item.getRule().getRight().get(i)));
            if (!follow.contains(Symbol.\u03b5)) {
                return follow;
            }
            follow.remove(Symbol.\u03b5);
        }
        follow.addAll(item.getLookahead());
        return follow;
    }

    public static LrParserAutomata generateParser(Grammar grammar) {
        return new LrParserConstructor(grammar).constructAutomata();
    }
}

