/*
 * Decompiled with CFR 0.152.
 */
package foundation.rpg.automata;

import foundation.rpg.automata.LrAction;
import foundation.rpg.automata.LrItem;
import foundation.rpg.automata.LrItemSet;
import foundation.rpg.grammar.Grammar;
import foundation.rpg.grammar.Symbol;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LrParserAutomata {
    private final LrItemSet start;
    private final Map<LrItemSet, LrItemSet> sets = new LinkedHashMap<LrItemSet, LrItemSet>();
    private final Map<LrItemSet, Map<Symbol, LrAction>> actions = new LinkedHashMap<LrItemSet, Map<Symbol, LrAction>>();
    private final Grammar grammar;

    public LrParserAutomata(LrItemSet start, Grammar grammar) {
        this.start = start;
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public boolean addState(LrItemSet itemSet) {
        return this.sets.putIfAbsent(itemSet, itemSet) == null;
    }

    public LrItemSet getStart() {
        return this.start;
    }

    public Set<LrItemSet> getSets() {
        return this.sets.keySet();
    }

    private void action(LrItemSet from, Symbol symbol, LrAction action) {
        Map actionMap = this.actions.computeIfAbsent(from, k -> new LinkedHashMap());
        if (actionMap.containsKey(symbol)) {
            LrAction currentAction = (LrAction)actionMap.get(symbol);
            if (action.priority() == currentAction.priority() && action.equals(currentAction)) {
                throw new IllegalStateException("Conflict at: " + from + " for symbol: " + symbol + ": " + currentAction + " / " + action + "\n\nCurrent parser state:\n" + this);
            }
            System.out.println("Resolving conflict using priority at: " + from + " for symbol: " + symbol + ": " + currentAction + " (priority=" + currentAction.priority() + ") / " + action + " (priority=" + action.priority() + ")");
            if (action.priority() > currentAction.priority()) {
                actionMap.put(symbol, action);
            }
        }
        actionMap.put(symbol, action);
    }

    public void transition(LrItemSet from, Symbol symbol, LrItemSet to) {
        this.action(from, symbol, new LrAction.Goto(this.sets.get(to)));
    }

    public void reduction(LrItemSet from, Symbol lookahead, LrItem item) {
        this.action(from, lookahead, new LrAction.Reduce(item));
    }

    public Map<Symbol, LrAction> actionsFor(LrItemSet set) {
        return this.actions.get(set);
    }

    public String toString() {
        return this.getSets().stream().map(Object::toString).collect(Collectors.joining("\n")) + "\n\n" + this.actions.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(transition -> ((LrItemSet)entry.getKey()).getName() + ": " + transition.getKey() + " -> " + transition.getValue())).collect(Collectors.joining("\n"));
    }

    public void accept(LrItemSet itemSet, LrItem lrItem) {
        this.action(itemSet, Symbol.any, new LrAction.Accept(lrItem));
    }
}

