package foundation.jpa.querydsl.order;

import foundation.rpg.parser.Element;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.End;
import java.io.IOException;
import foundation.rpg.parser.TokenBuilder;

public class OrderByLexer implements Lexer<State> {
	private final foundation.jpa.querydsl.order.OrderFactory factory;

	public OrderByLexer(foundation.jpa.querydsl.order.OrderFactory factory) {
		this.factory = factory;
	}

	public foundation.jpa.querydsl.order.OrderFactory getFactory() {
		return factory;
	}

	public Element<State> next(Input input) throws IOException {
		int state = 0;
		int symbol = input.lookahead();
		TokenBuilder builder = new TokenBuilder(input);
		if(symbol < 0) return new ElementEnd(new End(builder.build()));
		for(; true; symbol = builder.next()) {
			switch(state) {
				case 0:
					switch(symbol) {
						case 'a': state = 1; break;
						case 'd': state = 2; break;
						case 'f': state = 3; break;
						case ',': state = 4; break;
						case 'l': state = 5; break;
						case 'n': state = 6; break;
						case '.': state = 7; break;
						default:
							if(Lexer.matchesGroup('s', symbol)) { state = 8; break; }
							if(Lexer.matchesGroup('i', symbol)) { state = 9; break; }
							input.error("Unexpected character: '" + (char) symbol + "'");
					}
					break;
				case 1:
					if(symbol == 's') { state = 10; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 2:
					if(symbol == 'e') { state = 12; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 3:
					if(symbol == 'i') { state = 13; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 4:
					return new ElementComma(new foundation.rpg.common.symbols.Comma(builder.build()));
				case 5:
					if(symbol == 'a') { state = 14; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 6:
					if(symbol == 'u') { state = 15; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 7:
					return new ElementDot(new foundation.rpg.common.symbols.Dot(builder.build()));
				case 8:
					if(Lexer.matchesGroup('s', symbol)) { state = 8; break; }
					return new ElementWhiteSpace(new foundation.rpg.common.symbols.WhiteSpace(builder.build()));
				case 9:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 10:
					if(symbol == 'c') { state = 16; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 11:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 12:
					if(symbol == 's') { state = 17; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 13:
					if(symbol == 'r') { state = 18; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 14:
					if(symbol == 's') { state = 19; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 15:
					if(symbol == 'l') { state = 20; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 16:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementToken(builder.build());
				case 17:
					if(symbol == 'c') { state = 21; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 18:
					if(symbol == 's') { state = 22; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 19:
					if(symbol == 't') { state = 23; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 20:
					if(symbol == 'l') { state = 24; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 21:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementToken$(builder.build());
				case 22:
					if(symbol == 't') { state = 25; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 23:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementToken$$$$(builder.build());
				case 24:
					if(symbol == 's') { state = 26; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 25:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementToken$$$(builder.build());
				case 26:
					if(Lexer.matchesGroup('w', symbol)) { state = 11; break; }
					return new ElementToken$$(builder.build());
			}
		}
	}
}
