package foundation.jpa.querydsl;

import foundation.rpg.parser.Element;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.End;
import java.io.IOException;
import foundation.rpg.parser.TokenBuilder;

public class PredicateLexer implements Lexer<State> {
	private final foundation.jpa.querydsl.QueryFactory factory;

	public PredicateLexer(foundation.jpa.querydsl.QueryFactory factory) {
		this.factory = factory;
	}

	public foundation.jpa.querydsl.QueryFactory getFactory() {
		return factory;
	}

	public Element<State> next(Input input) throws IOException {
		int state = 0;
		int symbol = input.lookahead();
		TokenBuilder builder = new TokenBuilder(input);
		if(symbol < 0) return new ElementEnd(new End(builder.build()));
		for(; true; symbol = builder.next()) {
			switch(state) {
				case 0:
					switch(symbol) {
						case 'a': state = 1; break;
						case '!': state = 2; break;
						case '\'': state = 3; break;
						case '(': state = 4; break;
						case ')': state = 5; break;
						case 'i': state = 6; break;
						case ',': state = 7; break;
						case '=': state = 8; break;
						case 'n': state = 9; break;
						case '~': state = 10; break;
						case '.': state = 11; break;
						case 'o': state = 12; break;
						default:
							if(Lexer.matchesGroup('s', symbol)) { state = 13; break; }
							if(Lexer.matchesGroup('d', symbol)) { state = 14; break; }
							if(Lexer.matchesGroup('i', symbol)) { state = 15; break; }
							input.error("Unexpected character: '" + (char) symbol + "'");
					}
					break;
				case 1:
					if(symbol == 'n') { state = 16; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 2:
					if(symbol == '=') { state = 18; break; }
					input.error("Unexpected character: '" + (char) symbol + "'");
				case 3:
					switch(symbol) {
						case '\'': state = 19; break;
						case '\\': state = 20; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 21; break;
					}
					break;
				case 4:
					return new ElementLPar(new foundation.rpg.common.symbols.LPar(builder.build()));
				case 5:
					return new ElementRPar(new foundation.rpg.common.symbols.RPar(builder.build()));
				case 6:
					switch(symbol) {
						case 's': state = 22; break;
						case 'n': state = 23; break;
						default:
							if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
							return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
					}
					break;
				case 7:
					return new ElementComma(new foundation.rpg.common.symbols.Comma(builder.build()));
				case 8:
					return new ElementEqual(new foundation.rpg.common.symbols.Equal(builder.build()));
				case 9:
					switch(symbol) {
						case 'u': state = 24; break;
						case 'o': state = 25; break;
						default:
							if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
							return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
					}
					break;
				case 10:
					return new ElementTilda(new foundation.rpg.common.symbols.Tilda(builder.build()));
				case 11:
					return new ElementDot(new foundation.rpg.common.symbols.Dot(builder.build()));
				case 12:
					if(symbol == 'r') { state = 26; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 13:
					if(Lexer.matchesGroup('s', symbol)) { state = 13; break; }
					return new ElementWhiteSpace(new foundation.rpg.common.symbols.WhiteSpace(builder.build()));
				case 14:
					switch(symbol) {
						case 'e': state = 27; break;
						case 'E': state = 27; break;
						case '.': state = 27; break;
						default:
							if(Lexer.matchesGroup('d', symbol)) { state = 14; break; }
							return new ElementInteger(new java.lang.Integer(builder.build().getContent()));
					}
					break;
				case 15:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 16:
					if(symbol == 'd') { state = 28; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 17:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 18:
					return new ElementExclEqual(new foundation.rpg.common.symbols.ExclEqual(builder.build()));
				case 19:
					return new ElementString(new java.lang.String(builder.build().getContent()));
				case 20:
					switch(symbol) {
						case 'r': state = 29; break;
						case 't': state = 29; break;
						case '\'': state = 29; break;
						case '\\': state = 29; break;
						case 'n': state = 29; break;
						default:
							input.error("Unexpected character: '" + (char) symbol + "'");
					}
					break;
				case 21:
					switch(symbol) {
						case '\'': state = 19; break;
						case '\\': state = 20; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 21; break;
					}
					break;
				case 22:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIs(new foundation.rpg.common.symbols.Is(builder.build()));
				case 23:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIn(new foundation.rpg.common.symbols.In(builder.build()));
				case 24:
					if(symbol == 'l') { state = 30; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 25:
					if(symbol == 't') { state = 31; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 26:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementOr(new foundation.rpg.common.symbols.Or(builder.build()));
				case 27:
					if(Lexer.matchesGroup('d', symbol)) { state = 32; break; }
					input.error("Unexpected character: '" + (char) symbol + "'");
				case 28:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementAnd(new foundation.rpg.common.symbols.And(builder.build()));
				case 29:
					switch(symbol) {
						case '\'': state = 19; break;
						case '\\': state = 20; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 21; break;
					}
					break;
				case 30:
					if(symbol == 'l') { state = 33; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 31:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementNot(new foundation.rpg.common.symbols.Not(builder.build()));
				case 32:
					if(Lexer.matchesGroup('d', symbol)) { state = 32; break; }
					return new ElementDouble(new java.lang.Double(builder.build().getContent()));
				case 33:
					if(Lexer.matchesGroup('w', symbol)) { state = 17; break; }
					return new ElementNull(new foundation.rpg.common.symbols.Null(builder.build()));
			}
		}
	}
}
