/*
 * Decompiled with CFR 0.152.
 */
package foundation.jpa.querydsl;

import com.querydsl.core.types.Constant;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import foundation.jpa.querydsl.QueryUtils;
import foundation.rpg.Match;
import foundation.rpg.StartSymbol;
import foundation.rpg.common.precedence.LogicalAnd;
import foundation.rpg.common.precedence.LogicalOr;
import foundation.rpg.common.precedence.Relational;
import foundation.rpg.common.rules.CommaSeparated;
import foundation.rpg.common.symbols.And;
import foundation.rpg.common.symbols.Dot;
import foundation.rpg.common.symbols.Equal;
import foundation.rpg.common.symbols.Identifier;
import foundation.rpg.common.symbols.In;
import foundation.rpg.common.symbols.Is;
import foundation.rpg.common.symbols.LPar;
import foundation.rpg.common.symbols.Not;
import foundation.rpg.common.symbols.Null;
import foundation.rpg.common.symbols.Or;
import foundation.rpg.common.symbols.RPar;
import foundation.rpg.common.symbols.Tilda;
import foundation.rpg.common.symbols.WhiteSpace;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.core.convert.ConversionService;

public class QueryFactory {
    private final ConversionService conversionService;
    private final Map<String, Object> variables;
    private final EntityPath<?> root;

    public QueryFactory(ConversionService conversionService, Map<String, Object> variables, EntityPath<?> root) {
        this.conversionService = conversionService;
        this.variables = variables;
        this.root = root;
    }

    @StartSymbol
    Predicate is(@LogicalOr BooleanExpression expression) {
        return expression;
    }

    @LogicalOr BooleanExpression is(@LogicalOr BooleanExpression leftOperand, Or operator, @LogicalAnd BooleanExpression rightOperand) {
        return leftOperand.or((Predicate)rightOperand);
    }

    @LogicalAnd BooleanExpression is(@LogicalAnd BooleanExpression leftOperand, And operator, @Relational BooleanExpression rightOperand) {
        return leftOperand.and((Predicate)rightOperand);
    }

    @Relational BooleanExpression is(Not operator, LPar opening, @LogicalOr BooleanExpression expression, RPar closing) {
        return expression.not();
    }

    @Relational BooleanExpression is(LPar opening, @LogicalOr BooleanExpression expression, RPar closing) {
        return expression;
    }

    @Relational BooleanExpression is(Expression leftOperand, Equal operator, Expression rightOperand) {
        if (leftOperand instanceof EntityPath && rightOperand instanceof Constant) {
            return QueryUtils.resolve(leftOperand, rightOperand, this.conversionService);
        }
        if (rightOperand instanceof EntityPath && leftOperand instanceof Constant) {
            return QueryUtils.resolve(rightOperand, leftOperand, this.conversionService);
        }
        return QueryUtils.operation(Ops.EQ, leftOperand, rightOperand);
    }

    @Relational BooleanExpression is(Expression operand, Is is, Null nul) {
        return QueryUtils.operation(Ops.IS_NULL, operand);
    }

    @Relational BooleanExpression is(Expression operand, Not not, Null nul) {
        return QueryUtils.operation(Ops.IS_NOT_NULL, operand);
    }

    @Relational BooleanExpression is(Expression leftOperand, In operator, LPar opening, @CommaSeparated List<Expression> rightOperands, RPar closing) {
        return Expressions.asSimple((Expression)leftOperand).in(rightOperands);
    }

    @Relational BooleanExpression is(Expression leftOperand, Tilda operator, Expression rightOperand) {
        return QueryUtils.operation(Ops.LIKE, leftOperand, rightOperand);
    }

    @Relational BooleanExpression is(Expression expression) {
        return Expressions.asBoolean((Expression)expression);
    }

    Expression is(@Match(value="\\d+[.eE]\\d+") Double value) {
        return Expressions.constant((Object)value);
    }

    Expression is(@Match(value="\\d+") Integer value) {
        return Expressions.constant((Object)value);
    }

    Expression is(@Match(value="'([^'\\\\]|\\\\['\\\\rnt])*'") String value) {
        return Expressions.constant((Object)value.substring(1, value.length() - 1));
    }

    Object is(Identifier identifier) {
        String id = identifier.toString();
        return id.equals(this.root.toString()) ? this.root : (this.variables.containsKey(id) ? this.variables.get(id) : this.is(this.root, null, identifier));
    }

    Object is(Identifier identifier, LPar opening, @CommaSeparated List<Expression> parameters, RPar closing) {
        return this.is(this.root, null, identifier, opening, parameters, closing);
    }

    Expression is(Object object) {
        return object instanceof Expression ? (Expression)object : Expressions.constant((Object)object);
    }

    Object is(Object object, Dot operator, Identifier property) {
        String name = property.toString();
        Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            return type.getField(name).get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            try {
                return type.getMethod(name, new Class[0]).invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalArgumentException("No such field: " + name + " on entity " + object + ". Available fields are: " + Stream.of(object.getClass().getFields()).map(Field::getName).collect(Collectors.joining(", ")), ex);
            }
        }
    }

    Object is(Object object, Dot operator, Identifier property, LPar opening, @CommaSeparated List<Expression> parameters, RPar closing) {
        String name = property.toString();
        Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
        int size = parameters.size();
        Object[] arguments = parameters.stream().map(p -> p instanceof Constant ? ((Constant)p).getConstant() : p).toArray();
        for (Method method : type.getMethods()) {
            try {
                if (!method.getName().equals(name) || method.getParameterCount() != size) continue;
                Object[] a = IntStream.range(0, arguments.length).mapToObj(i -> this.conversionService.convert(arguments[i], method.getParameterTypes()[i])).toArray();
                return method.invoke(object, a);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Unable to invoke method: " + property.toString() + " with " + Arrays.toString(arguments) + " on entity " + object + ".", e);
            }
        }
        throw new IllegalArgumentException("No such method: " + property.toString() + " on entity " + object + " with " + size + " parameters.");
    }

    void ignore(WhiteSpace whiteSpace) {
    }
}

