package foundation.jpa.querydsl;

import foundation.rpg.parser.Element;
import foundation.rpg.parser.Lexer;
import foundation.rpg.parser.Input;
import foundation.rpg.parser.Position;
import foundation.rpg.parser.End;
import java.io.IOException;
import foundation.rpg.parser.TokenBuilder;

public class PredicateLexer implements Lexer<State> {
	private final foundation.jpa.querydsl.QueryFactory factory;

	public PredicateLexer(foundation.jpa.querydsl.QueryFactory factory) {
		this.factory = factory;
	}

	public foundation.jpa.querydsl.QueryFactory getFactory() {
		return factory;
	}

	public Element<State> next(Input input) throws IOException {
		int state = 0;
		int symbol = input.lookahead();
		TokenBuilder builder = new TokenBuilder(input);
		if(symbol < 0) return new ElementEnd(new End(builder.build()));
		for(; true; symbol = builder.next()) {
			switch(state) {
				case 0:
					switch(symbol) {
						case 'a': state = 1; break;
						case '\'': state = 2; break;
						case '(': state = 3; break;
						case ')': state = 4; break;
						case 'i': state = 5; break;
						case ',': state = 6; break;
						case '=': state = 7; break;
						case 'n': state = 8; break;
						case '~': state = 9; break;
						case '.': state = 10; break;
						case 'o': state = 11; break;
						default:
							if(Lexer.matchesGroup('s', symbol)) { state = 12; break; }
							if(Lexer.matchesGroup('d', symbol)) { state = 13; break; }
							if(Lexer.matchesGroup('i', symbol)) { state = 14; break; }
							input.error("Unexpected character: '" + (char) symbol + "'");
					}
					break;
				case 1:
					if(symbol == 'n') { state = 15; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 2:
					switch(symbol) {
						case '\'': state = 17; break;
						case '\\': state = 18; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 19; break;
					}
					break;
				case 3:
					return new ElementLPar(new foundation.rpg.common.symbols.LPar(builder.build()));
				case 4:
					return new ElementRPar(new foundation.rpg.common.symbols.RPar(builder.build()));
				case 5:
					if(symbol == 'n') { state = 20; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 6:
					return new ElementComma(new foundation.rpg.common.symbols.Comma(builder.build()));
				case 7:
					return new ElementEqual(new foundation.rpg.common.symbols.Equal(builder.build()));
				case 8:
					if(symbol == 'o') { state = 21; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 9:
					return new ElementTilda(new foundation.rpg.common.symbols.Tilda(builder.build()));
				case 10:
					return new ElementDot(new foundation.rpg.common.symbols.Dot(builder.build()));
				case 11:
					if(symbol == 'r') { state = 22; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 12:
					if(Lexer.matchesGroup('s', symbol)) { state = 12; break; }
					return new ElementWhiteSpace(new foundation.rpg.common.symbols.WhiteSpace(builder.build()));
				case 13:
					switch(symbol) {
						case 'e': state = 23; break;
						case 'E': state = 23; break;
						case '.': state = 23; break;
						default:
							if(Lexer.matchesGroup('d', symbol)) { state = 13; break; }
							return new ElementInteger(new java.lang.Integer(builder.build().getContent()));
					}
					break;
				case 14:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 15:
					if(symbol == 'd') { state = 24; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 16:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 17:
					return new ElementString(new java.lang.String(builder.build().getContent()));
				case 18:
					switch(symbol) {
						case 'r': state = 25; break;
						case 't': state = 25; break;
						case '\'': state = 25; break;
						case '\\': state = 25; break;
						case 'n': state = 25; break;
						default:
							input.error("Unexpected character: '" + (char) symbol + "'");
					}
					break;
				case 19:
					switch(symbol) {
						case '\'': state = 17; break;
						case '\\': state = 18; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 19; break;
					}
					break;
				case 20:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIn(new foundation.rpg.common.symbols.In(builder.build()));
				case 21:
					if(symbol == 't') { state = 26; break; }
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementIdentifier(new foundation.rpg.common.symbols.Identifier(builder.build()));
				case 22:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementOr(new foundation.rpg.common.symbols.Or(builder.build()));
				case 23:
					if(Lexer.matchesGroup('d', symbol)) { state = 27; break; }
					input.error("Unexpected character: '" + (char) symbol + "'");
				case 24:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementAnd(new foundation.rpg.common.symbols.And(builder.build()));
				case 25:
					switch(symbol) {
						case '\'': state = 17; break;
						case '\\': state = 18; break;
						default:
							if(symbol < 0) input.error("Unexpected end of input");
							state = 19; break;
					}
					break;
				case 26:
					if(Lexer.matchesGroup('w', symbol)) { state = 16; break; }
					return new ElementNot(new foundation.rpg.common.symbols.Not(builder.build()));
				case 27:
					if(Lexer.matchesGroup('d', symbol)) { state = 27; break; }
					return new ElementDouble(new java.lang.Double(builder.build().getContent()));
			}
		}
	}
}
