/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml.writer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class EscapingWriter
extends FilterWriter {
    public EscapingWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        switch (c) {
            case 60: {
                this.out.write("&lt;");
                break;
            }
            case 62: {
                this.out.write("&gt;");
                break;
            }
            case 38: {
                this.out.write("&amp;");
                break;
            }
            case 34: {
                this.out.write("&quot;");
                break;
            }
            case 39: {
                this.out.write("&apos;");
                break;
            }
            default: {
                this.out.write(c);
            }
        }
    }

    private int escape(char[] cbuf, int off, int end, String m) throws IOException {
        if (end > off) {
            this.out.write(cbuf, off, end - off);
        }
        this.out.write(m);
        return end + 1;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int s = off;
        block7: for (int i = off; i < end; ++i) {
            switch (cbuf[i]) {
                case '<': {
                    s = this.escape(cbuf, s, i, "&lt;");
                    continue block7;
                }
                case '>': {
                    s = this.escape(cbuf, s, i, "&gt;");
                    continue block7;
                }
                case '&': {
                    s = this.escape(cbuf, s, i, "&amp;");
                    continue block7;
                }
                case '\"': {
                    s = this.escape(cbuf, s, i, "&quot;");
                    continue block7;
                }
                case '\'': {
                    s = this.escape(cbuf, s, i, "&apos;");
                }
            }
        }
        if (end > s) {
            this.out.write(cbuf, s, end - s);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }
}

