/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml.writer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;

public class CDataWriter
extends FilterWriter {
    public static final IntUnaryOperator INVALID_CHARACTER_MAPPING = c -> c < 9 ? 32 : c;
    private final IntPredicate invalid = c -> c < 32;
    private final IntUnaryOperator operator;

    public CDataWriter(Writer out, IntUnaryOperator operator) {
        super(out);
        this.operator = operator;
    }

    public CDataWriter(Writer out) {
        this(out, INVALID_CHARACTER_MAPPING);
    }

    @Override
    public void write(int c) throws IOException {
        super.write(this.operator.applyAsInt(c));
    }

    private void writeCbuf(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            if (!this.invalid.test(cbuf[i])) continue;
            cbuf[i] = (char)this.operator.applyAsInt(cbuf[i]);
        }
        this.out.write(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writeCbuf(Arrays.copyOf(cbuf, cbuf.length), off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writeCbuf(str.toCharArray(), off, len);
    }
}

