/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import foundation.fluent.api.xml.DocumentWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Requirement {
    private Requirement() {
    }

    public static Object[] requirement(Consumer<DocumentWriter> actual, String expected) {
        return new Object[]{new DocumentWriterConsumer(actual, " should generate text"), expected};
    }

    public static Object[] negativeRequirement(Consumer<DocumentWriter> actual, String expected) {
        return new Object[]{new DocumentWriterConsumer(actual, " should throw"), expected};
    }

    private static class DocumentWriterConsumer
    implements Consumer<DocumentWriter> {
        private final Consumer<DocumentWriter> actual;
        private final String expectation;

        private DocumentWriterConsumer(Consumer<DocumentWriter> actual, String expectation) {
            this.actual = actual;
            this.expectation = expectation;
        }

        @Override
        public void accept(DocumentWriter documentWriter) {
            this.actual.accept(documentWriter);
        }

        public String toString() {
            ToStringInvocationHandler handler = new ToStringInvocationHandler("w");
            this.actual.accept((DocumentWriter)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DocumentWriter.class}, (InvocationHandler)handler));
            return handler.toString() + ' ' + this.expectation;
        }

        private class ToStringInvocationHandler
        implements InvocationHandler {
            private final String content;
            private final List<ToStringInvocationHandler> invocations = new ArrayList<ToStringInvocationHandler>();

            private ToStringInvocationHandler(String content) {
                this.content = content;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    return method.invoke((Object)this, new Object[0]);
                }
                String params = Objects.isNull(args) ? "" : Arrays.stream(args).map(arg -> arg instanceof String ? "\"" + arg + "\"" : String.valueOf(arg)).collect(Collectors.joining(", "));
                ToStringInvocationHandler handler = new ToStringInvocationHandler(method.getName() + '(' + params + ')');
                this.invocations.add(handler);
                if (method.getReturnType().equals(Void.TYPE)) {
                    return null;
                }
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
            }

            public String toString() {
                switch (this.invocations.size()) {
                    case 0: {
                        return this.content;
                    }
                    case 1: {
                        return this.content + '.' + this.invocations.get(0);
                    }
                }
                return this.content + this.invocations.stream().map(Objects::toString).collect(Collectors.joining(";\nvar.", ";\nvar.", ";"));
            }
        }
    }
}

