/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import foundation.fluent.api.xml.DocumentWriter;
import foundation.fluent.api.xml.DocumentWriterConfig;
import foundation.fluent.api.xml.DocumentWriterFactory;
import foundation.fluent.api.xml.ElementWriter;
import foundation.fluent.api.xml.Requirement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentWriterTest {
    @DataProvider
    public Object[][] data() {
        return new Object[][]{Requirement.requirement(w -> w.tag("element").end(), "<element/>"), Requirement.requirement(w -> {
            w.version(1.0).text("\n").tag("element");
            w.text("\n");
        }, "<?xml version='1.0'?>\n<element/>\n"), Requirement.requirement(w -> w.version(1.0).tag("element").end(), "<?xml version='1.0'?><element/>"), Requirement.requirement(w -> w.version(1.0).comment("Top level comment").tag("element").end(), "<?xml version='1.0'?><!-- Top level comment --><element/>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("element").close(), "<?xml version='1.0' encoding='UTF-8'?><element/>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("element").comment("Comment inside element").close(), "<?xml version='1.0' encoding='UTF-8'?><element><!-- Comment inside element --></element>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("element").attribute("a", "b").xmlns("http://my/uri").text("aha<").cdata("&uuu").cdata(" f").end(), "<?xml version='1.0' encoding='UTF-8'?><element a='b' xmlns='http://my/uri'>aha&lt;<![CDATA[&uuu f]]></element>"), Requirement.requirement(w -> {
            ElementWriter tag = w.tag("tag");
            tag.tag("one").attribute("a", "u").text("1");
            tag.tag("two").attribute("b", "v").text("2");
            tag.close();
        }, "<tag><one a='u'>1</one><two b='v'>2</two></tag>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("fluent", "tag").xmlns("fluent", "http://api.fluent.foundation/").tag("fluent", "api").close(), "<?xml version='1.0' encoding='UTF-8'?><fluent:tag xmlns:fluent='http://api.fluent.foundation/'><fluent:api/></fluent:tag>"), Requirement.requirement(w -> w.version(1.0).instruction("xml-stylesheet", "href='style.css' type='text/css'").tag("root").instruction("php", "phpinfo()").close(), "<?xml version='1.0'?><?xml-stylesheet href='style.css' type='text/css'?><root><?php phpinfo()?></root>"), Requirement.requirement(w -> w.doctype("html").tag("html").close(), "<!DOCTYPE html><html/>")};
    }

    @Test(dataProvider="data")
    public void testThat(Consumer<DocumentWriter> actual, String expected) throws ParserConfigurationException, IOException, SAXException {
        StringWriter writer = new StringWriter();
        actual.accept(DocumentWriterFactory.document((Writer)writer, (DocumentWriterConfig)DocumentWriterConfig.config().singleQuoteValue()));
        Assert.assertEquals((String)writer.toString(), (String)expected);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(writer.toString().getBytes()));
        System.out.println(document);
    }

    @Test
    public void testFlushOnDocumentWriter() throws IOException {
        Writer writer = (Writer)Mockito.mock(Writer.class);
        DocumentWriterFactory.document((Writer)writer).version(1.0).flush();
        ((Writer)Mockito.verify((Object)writer)).flush();
    }

    @Test
    public void testFlushOnContentWriter() throws IOException {
        Writer writer = (Writer)Mockito.mock(Writer.class);
        DocumentWriterFactory.document((Writer)writer).version(1.0).tag("root").text("aha").flush();
        ((Writer)Mockito.verify((Object)writer)).flush();
    }
}

