/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import foundation.fluent.api.xml.ContentWriter;
import foundation.fluent.api.xml.DocumentWriterFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DocumentWriterPerformanceSuite {
    @Test(invocationCount=5, enabled=false)
    public void testEscaping() throws IOException {
        FileWriter writer = new FileWriter("output.xml");
        ContentWriter cdata = DocumentWriterFactory.document((Writer)writer).version(1.0).encoding("UTF-8").tag("element").attribute("a", "b&").xmlns("http://my/uri").text("a\u0001ha< >").cdata("uuu").cdata(" f");
        for (int i = 0; i < 1000000; ++i) {
            cdata.tag("another").attribute("counter", String.valueOf(Math.random())).attribute("ouha", "h & a").text("fgdsfg ' & > <     ").cdata("fdsf \u0010 fdsff \u0002").tag("dalsi").attribute("ua", "au").end().end();
        }
        cdata.end().close();
    }

    @Test(invocationCount=5, enabled=false)
    public void testWriter() throws IOException, XMLStreamException {
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(new FileWriter("output2.xml"));
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("element");
        writer.writeAttribute("a", "b&");
        writer.writeNamespace("ns", "http://my/uri");
        writer.writeCharacters("aha < >");
        writer.writeCData("uuu");
        writer.writeCData(" f");
        for (int i = 0; i < 1000000; ++i) {
            writer.writeStartElement("another");
            writer.writeAttribute("counter", String.valueOf(Math.random()));
            writer.writeAttribute("ouha", "h & a");
            writer.writeCharacters("fgdsfg ' & > <     ");
            writer.writeCharacters("fdsf \u0010 fdsff \u0002");
            writer.writeStartElement("dalsi");
            writer.writeAttribute("ua", "au");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.close();
    }

    @Test(enabled=false)
    public void testAmp() throws XMLStreamException, IOException {
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(stringWriter);
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("element");
        writer.writeCharacters("&amp;");
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((String)stringWriter.toString(), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><element>&amp;</element>");
    }
}

