/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import foundation.fluent.api.xml.DocumentWriter;
import foundation.fluent.api.xml.DocumentWriterConfig;
import foundation.fluent.api.xml.DocumentWriterFactory;
import foundation.fluent.api.xml.ElementWriter;
import foundation.fluent.api.xml.Requirement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentWriterIndentationTest {
    @DataProvider
    public Object[][] data() {
        return new Object[][]{Requirement.requirement(w -> w.tag("element").end(), "<element/>"), Requirement.requirement(w -> w.version(1.0).tag("element").end(), "<?xml version='1.0'?>\n<element/>"), Requirement.requirement(w -> w.version(1.0).comment("Top level comment").tag("element").end(), "<?xml version='1.0'?>\n<!-- Top level comment -->\n<element/>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("element").comment("Comment inside element").close(), "<?xml version='1.0' encoding='UTF-8'?>\n<element>\n    <!-- Comment inside element -->\n</element>"), Requirement.requirement(w -> w.version(1.0).encoding("UTF-8").tag("element").attribute("a", "b").xmlns("http://my/uri").text("aha<").cdata("&uuu").cdata(" f").end(), "<?xml version='1.0' encoding='UTF-8'?>\n<element a='b' xmlns='http://my/uri'>\n    aha&lt;\n    <![CDATA[&uuu f]]>\n</element>"), Requirement.requirement(w -> {
            ElementWriter tag = w.tag("tag");
            tag.tag("one").attribute("a", "u").text("1");
            tag.tag("two").attribute("b", "v").text("2");
            tag.close();
        }, "<tag>\n    <one a='u'>\n        1\n    </one>\n    <two b='v'>\n        2\n    </two>\n</tag>"), Requirement.requirement(w -> w.version(1.0).instruction("xml-stylesheet", "href='style.css' type='text/css'").tag("root").instruction("php", "phpinfo()").close(), "<?xml version='1.0'?>\n<?xml-stylesheet href='style.css' type='text/css'?>\n<root>\n    <?php phpinfo()?>\n</root>")};
    }

    @Test(dataProvider="data")
    public void testThat(Consumer<DocumentWriter> actual, String expected) throws ParserConfigurationException, IOException, SAXException {
        StringWriter writer = new StringWriter();
        actual.accept(DocumentWriterFactory.document((Writer)writer, (DocumentWriterConfig)DocumentWriterConfig.config().singleQuoteValue().indentSpaces(4)));
        Assert.assertEquals((String)writer.toString(), (String)expected);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(writer.toString().getBytes()));
        System.out.println(document);
    }
}

