/*
 * Decompiled with CFR 0.152.
 */
package foundation.fluent.api.xml;

import foundation.fluent.api.xml.DocumentWriter;
import foundation.fluent.api.xml.DocumentWriterConfig;
import foundation.fluent.api.xml.DocumentWriterFactory;
import foundation.fluent.api.xml.Requirement;
import java.io.Writer;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DocumentWriterErrorsTest {
    @DataProvider
    public Object[][] data() {
        return new Object[][]{Requirement.negativeRequirement(w -> w.version(1.0).encoding("UTF-8").close(), "No root element created."), Requirement.negativeRequirement(w -> w.tag("root").end().end().close(), "No open element to close."), Requirement.negativeRequirement(w -> w.text("sfv").close(), "Cannot write text out of the root element."), Requirement.negativeRequirement(w -> w.cdata("sfv").close(), "Cannot write CDATA out of the root element."), Requirement.negativeRequirement(w -> {
            w.version(1.0).encoding("UTF-8");
            w.tag("root").end();
            w.tag("root").close();
        }, "Trying to output second root."), Requirement.negativeRequirement(w -> {
            w.tag("root").end();
            w.version(1.0);
        }, "XML spec must be first in the document.")};
    }

    @Test(dataProvider="data")
    public void testThat(Consumer<DocumentWriter> actual, String expected) {
        try {
            actual.accept(DocumentWriterFactory.document((Writer)new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            }, (DocumentWriterConfig)DocumentWriterConfig.config().singleQuoteValue()));
            throw new AssertionError((Object)("IllegalStateException with message '" + expected + "' expected, but no exception thrown."));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)expected);
            return;
        }
    }
}

