/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.dsl;

import fluent.validation.AbstractCheckDsl;
import fluent.validation.BasicChecks;
import fluent.validation.Check;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;

public final class LocalDateTimeCheck
extends AbstractCheckDsl<LocalDateTimeCheck, LocalDateTime> {
    private LocalDateTimeCheck(Check<? super LocalDateTime> check) {
        super(check, LocalDateTimeCheck::new);
    }

    public static LocalDateTimeCheck localDateTimeWith() {
        return new LocalDateTimeCheck(BasicChecks.anything());
    }

    public LocalDateTimeCheck date(Check<? super LocalDate> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::toLocalDate).matching(check);
    }

    public LocalDateTimeCheck time(Check<? super LocalTime> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::toLocalTime).matching(check);
    }

    public LocalDateTimeCheck year(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getYear).matching(check);
    }

    public LocalDateTimeCheck year(int expectedValue) {
        return this.year(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck month(Check<? super Month> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getMonth).matching(check);
    }

    public LocalDateTimeCheck month(Month expectedValue) {
        return this.month(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck monthValue(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getMonthValue).matching(check);
    }

    public LocalDateTimeCheck month(int expectedValue) {
        return this.monthValue(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck day(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getDayOfMonth).matching(check);
    }

    public LocalDateTimeCheck day(int expectedValue) {
        return this.day(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck dayOfYear(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getDayOfYear).matching(check);
    }

    public LocalDateTimeCheck dayOfYear(int expectedValue) {
        return this.dayOfYear(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck dayOfWeek(Check<? super DayOfWeek> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getDayOfWeek).matching(check);
    }

    public LocalDateTimeCheck dayOfWeek(DayOfWeek expectedValue) {
        return this.dayOfWeek(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck hour(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getHour).matching(check);
    }

    public LocalDateTimeCheck hour(int expectedValue) {
        return this.hour(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck minute(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getMinute).matching(check);
    }

    public LocalDateTimeCheck minute(int expectedValue) {
        return this.minute(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck second(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getSecond).matching(check);
    }

    public LocalDateTimeCheck second(int expectedValue) {
        return this.second(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateTimeCheck nano(Check<? super Integer> check) {
        return (LocalDateTimeCheck)this.has(LocalDateTime::getNano).matching(check);
    }

    public LocalDateTimeCheck nano(int expectedValue) {
        return this.nano(BasicChecks.equalTo(expectedValue));
    }
}

