/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.dsl;

import fluent.validation.AbstractCheckDsl;
import fluent.validation.BasicChecks;
import fluent.validation.Check;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;

public final class LocalDateCheck
extends AbstractCheckDsl<LocalDateCheck, LocalDate> {
    private LocalDateCheck(Check<? super LocalDate> check) {
        super(check, LocalDateCheck::new);
    }

    public static LocalDateCheck localDateWith() {
        return new LocalDateCheck(BasicChecks.anything());
    }

    public LocalDateCheck year(Check<? super Integer> check) {
        return (LocalDateCheck)this.has(LocalDate::getYear).matching(check);
    }

    public LocalDateCheck year(int expectedValue) {
        return this.year(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateCheck month(Check<? super Month> check) {
        return (LocalDateCheck)this.has(LocalDate::getMonth).matching(check);
    }

    public LocalDateCheck month(Month expectedValue) {
        return this.month(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateCheck monthValue(Check<? super Integer> check) {
        return (LocalDateCheck)this.has(LocalDate::getMonthValue).matching(check);
    }

    public LocalDateCheck month(int expectedValue) {
        return this.monthValue(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateCheck day(Check<? super Integer> check) {
        return (LocalDateCheck)this.has(LocalDate::getDayOfMonth).matching(check);
    }

    public LocalDateCheck day(int expectedValue) {
        return this.day(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateCheck dayOfYear(Check<? super Integer> check) {
        return (LocalDateCheck)this.has(LocalDate::getDayOfYear).matching(check);
    }

    public LocalDateCheck dayOfYear(int expectedValue) {
        return this.dayOfYear(BasicChecks.equalTo(expectedValue));
    }

    public LocalDateCheck dayOfWeek(Check<? super DayOfWeek> check) {
        return (LocalDateCheck)this.has(LocalDate::getDayOfWeek).matching(check);
    }

    public LocalDateCheck dayOfWeek(DayOfWeek expectedValue) {
        return this.dayOfWeek(BasicChecks.equalTo(expectedValue));
    }
}

