/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import fluent.validation.TransformationBuilder;
import fluent.validation.processor.Factory;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Factory
public final class XmlChecks {
    private static final XPath xPath = XPathFactory.newInstance().newXPath();
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    private XmlChecks() {
    }

    private static XPathExpression compile(String xPath) {
        try {
            return XmlChecks.xPath.compile(xPath);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Check<Object> matchesXPath(String xPath) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.check(xml -> Boolean.TRUE.equals(xPathExpression.evaluate(xml, XPathConstants.BOOLEAN)), xPath);
    }

    public static TransformationBuilder<Object, CheckBuilder<Object>> hasNode(String xPath, QName type) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.has(xPath, xml -> xPathExpression.evaluate(xml, type));
    }

    public static TransformationBuilder<Object, CheckBuilder<Object>> hasNode(String xPath) {
        return XmlChecks.hasNode(xPath, XPathConstants.NODE);
    }

    public static TransformationBuilder<Object, CheckBuilder<String>> hasTextContent(String xPath) {
        XPathExpression xPathExpression = XmlChecks.compile(xPath);
        return BasicChecks.has(xPath, xPathExpression::evaluate);
    }

    public static Check<String> parseXml(Check<? super Document> check) {
        return BasicChecks.transform(string -> factory.newDocumentBuilder().parse(new InputSource(new StringReader((String)string))), check);
    }

    public static Check<String> loadXml(Check<? super Document> check) {
        return BasicChecks.transform(string -> factory.newDocumentBuilder().parse((String)string), check);
    }
}

