/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.ThrowingRunnable;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

public final class ThrowingCheck
implements Check<ThrowingRunnable> {
    private final Check<? super Throwable> check;

    ThrowingCheck(Check<? super Throwable> check) {
        this.check = check;
    }

    @Override
    public Result evaluate(ThrowingRunnable data, ResultFactory factory) {
        try {
            data.run();
            return factory.expectation("no exception thrown", false);
        }
        catch (Throwable throwable) {
            Result result = this.check.evaluate(throwable, factory);
            return factory.named("throwing", factory.actual(throwable, result), result.passed());
        }
    }

    public ThrowingCheck withMessage(Check<? super String> check) {
        return new ThrowingCheck(BasicChecks.allOf(this.check, BasicChecks.has("message", Throwable::getMessage).matching(check)));
    }

    public ThrowingCheck withMessage(String expectedValue) {
        return this.withMessage(BasicChecks.equalTo(expectedValue));
    }

    public String toString() {
        return "throwing " + this.check;
    }
}

