/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Aggregator;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.Iterator;

final class SameOrderCheck<D>
implements Check<Iterator<D>> {
    private final String elementName;
    private final Iterable<Check<? super D>> checks;
    private final boolean full;
    private final boolean exact;

    SameOrderCheck(String elementName, Iterable<Check<? super D>> checks, boolean full, boolean exact) {
        this.elementName = elementName;
        this.checks = checks;
        this.full = full;
        this.exact = exact;
    }

    private boolean match(Check<? super D> check, Iterator<D> d, Aggregator resultBuilder, ResultFactory factory) {
        while (d.hasNext()) {
            D item = d.next();
            if (resultBuilder.add(check.evaluate(item, factory)).passed()) {
                return true;
            }
            if (!this.exact) continue;
            return false;
        }
        return false;
    }

    @Override
    public Result evaluate(Iterator<D> data, ResultFactory factory) {
        if (data == null) {
            return factory.expectation(this, false);
        }
        Aggregator resultBuilder = factory.aggregator(this);
        for (Check<? super D> check : this.checks) {
            if (this.match(check, data, resultBuilder, factory)) continue;
            return resultBuilder.build(check + " not matched by any " + this.elementName, false);
        }
        if (this.full && this.exact && data.hasNext()) {
            return resultBuilder.build("Extra " + this.elementName + " " + data.next(), false);
        }
        return resultBuilder.build(this.elementName + "s matched checks", true);
    }

    public String toString() {
        return this.elementName + "s matching " + this.checks;
    }
}

