/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.Predicate;
import fluent.validation.UncheckedInterruptedException;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

final class PredicateCheck<D>
implements Check<D> {
    private final Object expectation;
    private final Predicate<D> predicate;

    PredicateCheck(Object expectation, Predicate<D> predicate) {
        this.expectation = expectation;
        this.predicate = predicate;
    }

    public String toString() {
        return String.valueOf(this.expectation);
    }

    @Override
    public Result evaluate(D data, ResultFactory factory) {
        try {
            return factory.expectation(this.expectation, this.predicate.test(data));
        }
        catch (UncheckedInterruptedException interrupted) {
            throw interrupted;
        }
        catch (Error | Exception throwable) {
            return factory.error(throwable);
        }
    }
}

