/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.Arrays;

final class Or<D>
implements Check<D> {
    private final Check<? super D> left;
    private final Check<? super D> right;

    Or(Check<? super D> left, Check<? super D> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Result evaluate(D data, ResultFactory factory) {
        Result leftResult = this.left.evaluate(data, factory);
        Result rightResult = this.right.evaluate(data, factory);
        return factory.aggregation("", " or ", Arrays.asList(leftResult, rightResult), leftResult.passed() || rightResult.passed());
    }

    public String toString() {
        return this.left + " or " + this.right;
    }

    @Override
    public <U extends D> Check<U> and(Check<? super U> operand) {
        return this.left.or(this.right.and(operand));
    }
}

