/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.Transformation;
import fluent.validation.processor.Factory;
import java.math.BigDecimal;
import java.math.BigInteger;

@Factory
public final class NumericChecks {
    private static final Double DEFAULT_TOLERANCE = Double.parseDouble(System.getProperty("check.default.tolerance", "0.000001"));

    private NumericChecks() {
    }

    public static Check<Double> closeTo(double expectedValue, double precision) {
        return BasicChecks.check(data -> Math.abs(expectedValue - data) < precision, "<" + expectedValue + " \u00b1" + precision + ">");
    }

    public static Check<Float> closeTo(float expectedValue, float precision) {
        return BasicChecks.check(data -> Math.abs(expectedValue - data.floatValue()) < precision, expectedValue + " \u00b1" + precision);
    }

    public static Check<BigDecimal> closeTo(BigDecimal expectedValue, BigDecimal precision) {
        return BasicChecks.check(data -> expectedValue.subtract((BigDecimal)data).abs().compareTo(precision) < 0, expectedValue + " \u00b1" + precision);
    }

    public static Check<Double> equalTo(Double expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue, DEFAULT_TOLERANCE);
    }

    public static Check<Float> equalTo(Float expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue.floatValue(), DEFAULT_TOLERANCE.floatValue());
    }

    public static Check<BigDecimal> equalTo(BigDecimal expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue, BigDecimal.valueOf(DEFAULT_TOLERANCE));
    }

    public static Check<String> parseDouble(Check<? super Double> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Double::parseDouble), check);
    }

    public static Check<String> parseDouble(Double expectedValue) {
        return NumericChecks.parseDouble(NumericChecks.equalTo(expectedValue));
    }

    public static Check<String> parseDouble(double expectedValue) {
        return NumericChecks.parseDouble(NumericChecks.equalTo(expectedValue));
    }

    public static Check<String> parseFloat(Check<? super Float> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Float::parseFloat), check);
    }

    public static Check<String> parseFloat(Float expectedValue) {
        return NumericChecks.parseFloat(NumericChecks.equalTo(expectedValue));
    }

    public static Check<String> parseFloat(float expectedValue) {
        return NumericChecks.parseFloat(NumericChecks.equalTo(Float.valueOf(expectedValue)));
    }

    public static Check<String> parseInt(Check<? super Integer> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Integer::parseInt), check);
    }

    public static Check<String> parseInt(Integer expectedValue) {
        return NumericChecks.parseInt(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseInt(int expectedValue) {
        return NumericChecks.parseInt(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseLong(Check<? super Long> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Long::parseLong), check);
    }

    public static Check<String> parseLong(Long expectedValue) {
        return NumericChecks.parseLong(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseLong(long expectedValue) {
        return NumericChecks.parseLong(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseShort(Check<? super Short> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Short::parseShort), check);
    }

    public static Check<String> parseShort(Short expectedValue) {
        return NumericChecks.parseShort(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseShort(short expectedValue) {
        return NumericChecks.parseShort(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseBigDecimal(Check<? super BigDecimal> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(BigDecimal::new), check);
    }

    public static Check<String> parseBigInt(Check<? super BigInteger> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(BigInteger::new), check);
    }

    public static Check<String> parseByte(Check<? super Byte> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Byte::parseByte), check);
    }

    public static Check<String> parseByte(Byte expectedValue) {
        return NumericChecks.parseByte(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseByte(byte expectedValue) {
        return NumericChecks.parseByte(BasicChecks.equalTo(expectedValue));
    }

    public static Check<String> parseBoolean(Check<? super Boolean> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(Boolean::parseBoolean), check);
    }

    public static Check<String> parseBoolean(Boolean expectedValue) {
        return NumericChecks.parseBoolean(BasicChecks.equalTo(expectedValue));
    }
}

