/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.AnyOrderCheck;
import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.Functions;
import fluent.validation.Items;
import fluent.validation.MapItemCheck;
import fluent.validation.Quantifier;
import fluent.validation.Repeater;
import fluent.validation.SameOrderCheck;
import fluent.validation.processor.Factory;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;

@Factory
public final class CollectionChecks {
    private CollectionChecks() {
    }

    public static <D> Check<Iterable<D>> exists(String elementName, Check<? super D> check) {
        return CollectionChecks.collection(CollectionChecks.contains(elementName, Items.itemsMatching(check)));
    }

    public static <D> Check<Iterable<D>> every(String elementName, Check<? super D> check) {
        return new Quantifier<D>(elementName, Quantifier.Type.every, check);
    }

    public static <D> Check<D> repeatMax(Check<D> attemptCheck, int max) {
        return CollectionChecks.repeatMax(attemptCheck, max, Duration.ofSeconds(1L));
    }

    public static <D> Check<D> repeatMax(Check<D> itemCheck, int max, Duration delay) {
        return BasicChecks.has("Try max " + max + " times", i -> Repeater.repeat(i, max, delay)).matching(CollectionChecks.exists("Attempt", itemCheck));
    }

    public static <T> Check<Iterator<T>> startsWith(String elementName, Items<T> prefix) {
        return new SameOrderCheck(elementName, Items.checks(prefix), false, true);
    }

    public static <T> Check<Iterator<T>> contains(String elementName, Items<T> elementChecks) {
        return new SameOrderCheck(elementName, Items.checks(elementChecks), false, false);
    }

    public static <T> Check<Iterator<T>> equalTo(String elementName, Items<T> elementChecks) {
        return new SameOrderCheck(elementName, Items.checks(elementChecks), true, true);
    }

    public static <T> Check<Iterator<T>> startsWith(Items<T> prefix) {
        return CollectionChecks.startsWith("Item", prefix);
    }

    public static <T> Check<Iterator<T>> contains(Items<T> elementChecks) {
        return CollectionChecks.contains("Item", elementChecks);
    }

    public static <T> Check<Iterator<T>> equalTo(Items<T> elementChecks) {
        return CollectionChecks.equalTo("Item", elementChecks);
    }

    public static <T> Check<Iterator<T>> startsInAnyOrderWith(String elementName, Items<T> prefixElementChecks) {
        return new AnyOrderCheck(elementName, Items.checks(prefixElementChecks), false, true, false);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrder(String elementName, Items<T> elementChecks) {
        return new AnyOrderCheck(elementName, Items.checks(elementChecks), false, false, false);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrderOnly(String elementName, Items<T> elementChecks) {
        return new AnyOrderCheck(elementName, Items.checks(elementChecks), false, false, true);
    }

    public static <T> Check<Iterator<T>> equalInAnyOrderTo(String elementName, Items<T> elementChecks) {
        return new AnyOrderCheck(elementName, Items.checks(elementChecks), true, true, false);
    }

    public static <T> Check<Iterator<T>> startsInAnyOrderWith(Items<T> prefixElementChecks) {
        return CollectionChecks.startsInAnyOrderWith("Item", prefixElementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrder(Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrder("Item", elementChecks);
    }

    public static <T> Check<Iterator<T>> containsInAnyOrderOnly(Items<T> elementChecks) {
        return CollectionChecks.containsInAnyOrderOnly("Item", elementChecks);
    }

    public static <T> Check<Iterator<T>> equalInAnyOrderTo(Items<T> elementChecks) {
        return CollectionChecks.equalInAnyOrderTo("Item", elementChecks);
    }

    public static <T> Check<Iterable<T>> collection(Check<Iterator<T>> check) {
        return BasicChecks.requireNotNull(BasicChecks.transform(Iterable::iterator, check));
    }

    public static <T> Check<T[]> array(Check<Iterator<T>> check) {
        return BasicChecks.requireNotNull(BasicChecks.transform(array -> Arrays.asList(array).iterator(), check));
    }

    public static <T> Check<Queue<T>> queue(Check<Iterator<T>> check) {
        return BasicChecks.requireNotNull(BasicChecks.transform(Functions::queueIterator, check));
    }

    public static <T> Check<BlockingQueue<T>> blockingQueue(Check<Iterator<T>> check, Duration timeout) {
        return BasicChecks.requireNotNull(BasicChecks.transform(queue -> Functions.blockingQueueIterator(queue, timeout.toMillis()), check));
    }

    public static <D> Check<Collection<D>> emptyCollection() {
        return BasicChecks.nullableCheck(data -> Objects.isNull(data) || data.isEmpty(), "is empty collection");
    }

    public static <D> Check<Collection<D>> subsetOf(Collection<D> superSet) {
        return BasicChecks.check(superSet::containsAll, "Superset of " + superSet);
    }

    @SafeVarargs
    public static <D> Check<Collection<D>> subsetOf(D ... superSet) {
        return CollectionChecks.subsetOf(new HashSet<D>(Arrays.asList(superSet)));
    }

    public static <D> Check<Collection<D>> hasSize(int size) {
        return BasicChecks.check(data -> data.size() == size, "has size " + size);
    }

    public static <D> Check<Collection<D>> containsAll(Collection<D> items) {
        return BasicChecks.check(data -> data.containsAll(items), "Has items " + items);
    }

    @SafeVarargs
    public static <D> Check<Collection<D>> containsAll(D ... items) {
        return CollectionChecks.containsAll(Arrays.asList(items));
    }

    public static <K, V> Check<Map<K, V>> mapHas(K key, Check<? super V> check) {
        return new MapItemCheck<K, V>(key, check);
    }

    public static <D> Check<D[]> emptyArray() {
        return BasicChecks.check(data -> ((Object[])data).length == 0, "is empty array");
    }

    public static <D> Check<D[]> emptyArrayOrNull() {
        return BasicChecks.nullableCheck(data -> Objects.isNull(data) || ((Object[])data).length == 0, "is empty array");
    }
}

