/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.And;
import fluent.validation.Anything;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import fluent.validation.CustomResultFactoryCheck;
import fluent.validation.DoubleCheck;
import fluent.validation.NamedCheck;
import fluent.validation.NegativeCheck;
import fluent.validation.Or;
import fluent.validation.Predicate;
import fluent.validation.PredicateCheck;
import fluent.validation.SoftCheck;
import fluent.validation.ThrowingCheck;
import fluent.validation.Transformation;
import fluent.validation.TransformationBuilder;
import fluent.validation.TransformedCheck;
import fluent.validation.Value;
import fluent.validation.processor.Factory;
import fluent.validation.result.ResultFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

@Factory
public final class BasicChecks {
    private static final Check<Object> IS_NULL = BasicChecks.sameInstance(null);
    private static final Check<Object> NOT_NULL = BasicChecks.not(IS_NULL);
    private static final Check<Object> ANYTHING = new Anything<Object>();

    private BasicChecks() {
    }

    public static <D> Check<D> nullableCheck(Predicate<D> predicate, String expectationDescription) {
        return new PredicateCheck<D>(expectationDescription, predicate);
    }

    public static <D> Check<D> require(Check<? super D> requirement, Check<? super D> check) {
        return new DoubleCheck<D>(requirement, check);
    }

    public static <D> Check<D> requireNotNull(Check<D> check) {
        return BasicChecks.require(BasicChecks.isNotNull(), check);
    }

    public static <D> Check<D> check(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.requireNotNull(BasicChecks.nullableCheck(predicate, expectationDescription));
    }

    public static <D> Check<D> sameInstance(D expectedInstance) {
        return BasicChecks.nullableCheck(data -> data == expectedInstance, "<" + expectedInstance + ">");
    }

    public static <D> Check<D> equalTo(D expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : BasicChecks.nullableCheck(expectedValue::equals, "<" + expectedValue + ">");
    }

    public static <D> Check<D> is(D expectedValue) {
        return BasicChecks.equalTo(expectedValue);
    }

    public static Check<Object> isNull() {
        return IS_NULL;
    }

    public static Check<Object> isNotNull() {
        return NOT_NULL;
    }

    public static Check<Object> anything() {
        return ANYTHING;
    }

    private static Check<Object> instanceOf(String prefix, Class<?> expectedClass) {
        return BasicChecks.nullableCheck(expectedClass::isInstance, prefix + " " + expectedClass);
    }

    public static Check<Object> instanceOf(Class<?> expectedClass) {
        return BasicChecks.instanceOf("instance of", expectedClass);
    }

    public static Check<Object> isA(Class<?> expectedClass) {
        return BasicChecks.instanceOf("is a", expectedClass);
    }

    public static Check<Object> isAn(Class<?> expectedClass) {
        return BasicChecks.instanceOf("is an", expectedClass);
    }

    public static Check<Object> a(Class<?> expectedClass) {
        return BasicChecks.isA(expectedClass);
    }

    public static Check<Object> an(Class<?> expectedClass) {
        return BasicChecks.isAn(expectedClass);
    }

    public static Check<Object> sameClass(Class<?> expectedClass) {
        return BasicChecks.has("class", Object::getClass).matching(BasicChecks.equalTo(expectedClass));
    }

    public static <D> Check<D> not(Check<D> positiveCheck) {
        return new NegativeCheck<D>(positiveCheck);
    }

    public static <D> Check<D> not(D positiveValue) {
        return BasicChecks.not(BasicChecks.equalTo(positiveValue));
    }

    public static <D> Check<D> oneOf(Collection<D> alternatives) {
        return BasicChecks.nullableCheck(alternatives::contains, "One of " + alternatives);
    }

    @SafeVarargs
    public static <D> Check<D> oneOf(D ... alternatives) {
        return BasicChecks.oneOf(new HashSet<D>(Arrays.asList(alternatives)));
    }

    private static <D> Check<D> multipleOperands(Iterable<Check<? super D>> operands, boolean andOperator) {
        Iterator<Check<D>> iterator = operands.iterator();
        if (!iterator.hasNext()) {
            return BasicChecks.nullableCheck(data -> andOperator, "empty " + (andOperator ? "allOf" : "anyOf") + " formula");
        }
        Check<? super D> next = iterator.next();
        while (iterator.hasNext()) {
            next = andOperator ? new And<D>(next, iterator.next()) : new Or<D>(next, iterator.next());
        }
        return next;
    }

    public static <D> Check<D> anyOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.multipleOperands(operands, false);
    }

    @SafeVarargs
    public static <D> Check<D> anyOf(Check<? super D> ... operands) {
        return BasicChecks.anyOf(Arrays.asList(operands));
    }

    public static <D> Check<D> allOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.multipleOperands(operands, true);
    }

    @SafeVarargs
    public static <D> Check<D> allOf(Check<? super D> ... operands) {
        return BasicChecks.allOf(Arrays.asList(operands));
    }

    public static <D, V> Check<D> transform(Transformation<? super D, V> transformation, Check<? super V> check) {
        return new TransformedCheck<D, V>(transformation, check);
    }

    public static <D, V> Check<D> compose(String name, Transformation<? super D, V> transformation, Check<? super V> check) {
        return name == null ? BasicChecks.transform(transformation, check) : new NamedCheck<D>(name, BasicChecks.transform(transformation, check));
    }

    public static <D, V> Check<D> compose(Transformation<? super D, V> transformation, Check<? super V> check) {
        return new NamedCheck<D>(transformation.getMethodName(), BasicChecks.transform(transformation, check));
    }

    public static <D, V> TransformationBuilder<V, CheckBuilder<D>> has(String name, Transformation<? super D, V> transformation) {
        return condition -> new CheckBuilder.Impl(BasicChecks.requireNotNull(BasicChecks.compose(name, transformation, condition)));
    }

    public static <D, V> TransformationBuilder<V, CheckBuilder<D>> has(Transformation<? super D, V> transformation) {
        return BasicChecks.has(transformation.getMethodName(), transformation);
    }

    public static <D, V> TransformationBuilder<V, CheckBuilder<D>> nullableHas(String name, Transformation<? super D, V> transformation) {
        return condition -> new CheckBuilder.Impl(BasicChecks.compose(name, Transformation.dontTransformNull(transformation), condition));
    }

    public static <D, V> TransformationBuilder<V, CheckBuilder<D>> nullableHas(Transformation<? super D, V> transformation) {
        return BasicChecks.nullableHas(transformation.getMethodName(), transformation);
    }

    public static <V> TransformationBuilder<V, Check<V>> as(Class<V> type) {
        return condition -> BasicChecks.require(BasicChecks.instanceOf(type), BasicChecks.compose("as " + type.getSimpleName(), type::cast, condition));
    }

    public static Check<Throwable> message(Check<? super String> check) {
        return BasicChecks.compose("message", Throwable::getMessage, check);
    }

    public static ThrowingCheck throwing(Check<? super Throwable> check) {
        return new ThrowingCheck(check);
    }

    public static ThrowingCheck throwing(Class<? extends Throwable> expectedType) {
        return BasicChecks.throwing(BasicChecks.a(expectedType));
    }

    public static <D> Check<D> createBuilder() {
        return new Anything();
    }

    public static <D> Check<D> createBuilderWith(Check<D> check) {
        return check;
    }

    public static <D> Check<D> which(Check<D> check) {
        return BasicChecks.createBuilderWith(check);
    }

    public static <D> CheckBuilder<D> dsl() {
        return new CheckBuilder.Impl();
    }

    public static <D> Value<D> value() {
        return new Value();
    }

    public static <D> Check<D> softCheck(Check<D> check) {
        return new SoftCheck<D>(check);
    }

    public static <D> Check<D> customResultFactory(Check<D> check, ResultFactory customResultFactory) {
        return new CustomResultFactoryCheck<D>(check, customResultFactory);
    }
}

