/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.result;

import fluent.validation.Check;
import fluent.validation.result.ExpectationVisitor;
import fluent.validation.result.Result;
import fluent.validation.result.ResultVisitor;
import fluent.validation.result.TableInResult;
import java.util.List;

public final class MismatchResultVisitor
implements ResultVisitor {
    private final boolean failureIndicator;
    private final Object actualValueDescription;
    private final StringBuilder builder;
    private final String prefix;

    private MismatchResultVisitor(boolean failureIndicator, Object actualValueDescription, StringBuilder builder, String prefix) {
        this.failureIndicator = failureIndicator;
        this.actualValueDescription = actualValueDescription;
        this.builder = builder;
        this.prefix = prefix;
    }

    private MismatchResultVisitor(Object actualValueDescription, String prefix) {
        this(false, actualValueDescription, new StringBuilder(), prefix);
    }

    public MismatchResultVisitor() {
        this(null, "\n\t");
    }

    @Override
    public ResultVisitor visit(Result result) {
        this.builder.append("expected: ");
        new ExpectationVisitor(this.builder).visit(result);
        result.accept(this);
        return this;
    }

    @Override
    public void actual(Object actualValue, Result result) {
        result.accept(new MismatchResultVisitor(this.failureIndicator, actualValue, this.builder, this.prefix));
    }

    @Override
    public void expectation(Object expectation, boolean result) {
        this.builder.append(" but was: <").append(this.actualValueDescription).append('>');
    }

    @Override
    public void transformation(Object name, Result dependency, boolean result) {
        dependency.accept(this);
    }

    @Override
    public void aggregation(Object description, String glue, List<Result> itemResults, boolean result) {
        this.builder.append(" but was: ").append(this.actualValueDescription);
        itemResults.stream().filter(r -> r.passed() == this.failureIndicator).forEach(r -> {
            this.builder.append(this.prefix).append("+ ");
            new MismatchResultVisitor(this.failureIndicator, this.actualValueDescription, this.builder, this.prefix + '\n').visit((Result)r);
        });
    }

    @Override
    public void tableAggregation(Object prefix, List<Check<?>> checks, List<?> items, List<TableInResult.Cell> results, boolean value) {
        this.builder.append(" but: ").append(this.actualValueDescription);
        boolean[] rows = new boolean[checks.size()];
        boolean[] cols = new boolean[items.size()];
        results.forEach(cell -> {
            if (cell.getResult().passed()) {
                rows[cell.getRow()] = true;
                cols[cell.getColumn()] = true;
            }
        });
        results.stream().filter(cell -> !rows[cell.getRow()] && !cols[cell.getColumn()]).forEach(r -> {
            this.builder.append(this.prefix).append("+ ");
            new MismatchResultVisitor(this.failureIndicator, items.get(r.getColumn()), this.builder, this.prefix + '\n').visit(r.getResult());
        });
    }

    @Override
    public void error(Throwable throwable) {
        this.builder.append(" has thrown ").append(throwable);
    }

    @Override
    public void invert(Result result) {
        result.accept(new MismatchResultVisitor(!this.failureIndicator, this.actualValueDescription, this.builder, this.prefix));
    }

    @Override
    public void soft(Result result) {
        result.accept(this);
    }

    public String toString() {
        return this.builder.toString();
    }
}

