/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.dsl;

import fluent.validation.AbstractCheckDsl;
import fluent.validation.BasicChecks;
import fluent.validation.Check;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZonedDateTime;

public final class ZonedDateTimeCheck
extends AbstractCheckDsl<ZonedDateTimeCheck, ZonedDateTime> {
    private ZonedDateTimeCheck(Check<? super ZonedDateTime> check) {
        super(check, ZonedDateTimeCheck::new);
    }

    public static ZonedDateTimeCheck zonedDateTimeWith() {
        return new ZonedDateTimeCheck(BasicChecks.anything());
    }

    public ZonedDateTimeCheck date(Check<? super LocalDate> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::toLocalDate).matching(check);
    }

    public ZonedDateTimeCheck time(Check<? super LocalTime> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::toLocalTime).matching(check);
    }

    public ZonedDateTimeCheck year(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getYear).matching(check);
    }

    public ZonedDateTimeCheck year(int expectedValue) {
        return this.year(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck month(Check<? super Month> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getMonth).matching(check);
    }

    public ZonedDateTimeCheck month(Month expectedValue) {
        return this.month(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck monthValue(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getMonthValue).matching(check);
    }

    public ZonedDateTimeCheck month(int expectedValue) {
        return this.monthValue(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck day(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getDayOfMonth).matching(check);
    }

    public ZonedDateTimeCheck day(int expectedValue) {
        return this.day(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck dayOfYear(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getDayOfYear).matching(check);
    }

    public ZonedDateTimeCheck dayOfYear(int expectedValue) {
        return this.dayOfYear(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck dayOfWeek(Check<? super DayOfWeek> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getDayOfWeek).matching(check);
    }

    public ZonedDateTimeCheck dayOfWeek(DayOfWeek expectedValue) {
        return this.dayOfWeek(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck hour(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getHour).matching(check);
    }

    public ZonedDateTimeCheck hour(int expectedValue) {
        return this.hour(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck minute(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getMinute).matching(check);
    }

    public ZonedDateTimeCheck minute(int expectedValue) {
        return this.minute(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck second(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getSecond).matching(check);
    }

    public ZonedDateTimeCheck second(int expectedValue) {
        return this.second(BasicChecks.equalTo(expectedValue));
    }

    public ZonedDateTimeCheck nano(Check<? super Integer> check) {
        return (ZonedDateTimeCheck)this.withField(ZonedDateTime::getNano).matching(check);
    }

    public ZonedDateTimeCheck nano(int expectedValue) {
        return this.nano(BasicChecks.equalTo(expectedValue));
    }
}

