/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.Transformation;

@FunctionalInterface
public interface TransformationBuilder<V, R> {
    public R matching(Check<? super V> var1);

    default public R equalTo(V expectedValue) {
        return this.matching(BasicChecks.equalTo(expectedValue));
    }

    default public <U> TransformationBuilder<U, R> having(String name, Transformation<V, U> transformation) {
        return check -> this.matching(BasicChecks.compose(name, transformation, check));
    }

    default public <U> TransformationBuilder<U, R> having(Transformation<V, U> transformation) {
        return this.having(transformation.getMethodName(), transformation);
    }
}

