/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Objects;

@FunctionalInterface
public interface Transformation<F, T>
extends Serializable {
    public T apply(F var1) throws Exception;

    default public String getMethodName() {
        try {
            Method writeReplace = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda sl = (SerializedLambda)writeReplace.invoke((Object)this, new Object[0]);
            writeReplace.setAccessible(false);
            String methodName = sl.getImplMethodName();
            return methodName.startsWith("get") ? methodName.substring(3) : methodName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <F, T> Transformation<F, T> dontTransformNull(final Transformation<F, T> transformation) {
        return new Transformation<F, T>(){

            @Override
            public T apply(F f) throws Exception {
                return Objects.isNull(f) ? null : (Object)transformation.apply(f);
            }

            @Override
            public String getMethodName() {
                return transformation.getMethodName();
            }
        };
    }
}

