/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import fluent.validation.result.TableAggregator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class ResultSetCheckInAnyOrder
extends Check<ResultSet> {
    private final ArrayList<Check<? super ResultSet>> checks;
    private final boolean full;
    private final boolean exact;

    ResultSetCheckInAnyOrder(Collection<Check<? super ResultSet>> checks, boolean full, boolean exact) {
        this.checks = new ArrayList<Check<? super ResultSet>>(checks);
        this.full = full;
        this.exact = exact;
    }

    private boolean matchesAnyAndRemoves(ResultSet item, List<Integer> rows, int column, TableAggregator<ResultSet> table, ResultFactory factory) {
        Iterator<Integer> c = rows.iterator();
        while (c.hasNext()) {
            int row = c.next();
            Result result = this.checks.get(row).evaluate(item, factory);
            table.cell(row, column, result);
            if (!result.passed()) continue;
            c.remove();
            return true;
        }
        return false;
    }

    @Override
    public Result evaluate(ResultSet data, ResultFactory factory) {
        if (data == null) {
            return factory.expectation(this, false);
        }
        TableAggregator resultBuilder = factory.table(this, this.checks);
        List rows = IntStream.range(0, this.checks.size()).boxed().collect(Collectors.toCollection(LinkedList::new));
        try {
            while (data.next()) {
                int column = resultBuilder.column("record " + data.getRow());
                if (rows.isEmpty()) {
                    return this.full ? resultBuilder.build("Extra items found", false) : resultBuilder.build("Prefix matched", true);
                }
                if (this.matchesAnyAndRemoves(data, rows, column, resultBuilder, factory) || !this.exact) continue;
                return resultBuilder.build("Extra items found", false);
            }
        }
        catch (SQLException e) {
            return resultBuilder.build(e.getMessage(), false);
        }
        return resultBuilder.build(rows.isEmpty() ? "All checks satisfied" : "" + rows.size() + " checks not satisfied", rows.isEmpty());
    }

    @Override
    public String toString() {
        return "Records matching in any order " + this.checks;
    }
}

