/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Aggregator;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

final class Quantifier<D>
extends Check<Iterable<D>> {
    private final String elementName;
    private final Type type;
    private final Check<? super D> check;

    Quantifier(String elementName, Type type, Check<? super D> check) {
        this.elementName = elementName;
        this.type = type;
        this.check = check;
    }

    @Override
    public Result evaluate(Iterable<D> data, ResultFactory factory) {
        Aggregator itemResults = factory.aggregator(this);
        boolean end = this.type == Type.exists;
        for (D item : data) {
            if (itemResults.add(this.check.evaluate(item, factory)).passed() != end) continue;
            return end ? itemResults.build(this.elementName + " " + this.check + " found", true) : itemResults.build(item + " doesn't match " + this.check, false);
        }
        return end ? itemResults.build("No " + this.elementName + " " + this.check + " found", false) : itemResults.build("All " + this.elementName + "s matched " + this.check, true);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + " " + this.elementName + " " + this.check;
    }

    static enum Type {
        exists,
        every;

    }
}

