/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.dsl.LocalDateCheck;
import fluent.validation.dsl.LocalDateTimeCheck;
import fluent.validation.dsl.LocalTimeCheck;
import fluent.validation.dsl.ZonedDateTimeCheck;
import fluent.validation.processor.Factory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@Factory
public final class DateTimeChecks {
    private DateTimeChecks() {
    }

    public static Check<LocalDateTime> date(Check<? super LocalDate> dateCheck) {
        return BasicChecks.compose(LocalDateTime::toLocalDate, dateCheck);
    }

    public static Check<LocalDateTime> time(Check<? super LocalTime> dateCheck) {
        return BasicChecks.compose(LocalDateTime::toLocalTime, dateCheck);
    }

    public static Check<LocalDateTime> zoned(Check<? super ZonedDateTime> zonedDateTimeCheck, ZoneId zoneId) {
        return BasicChecks.compose(local -> local.atZone(zoneId), zonedDateTimeCheck);
    }

    public static Check<LocalDateTime> zoned(Check<? super ZonedDateTime> zonedDateTimeCheck) {
        return DateTimeChecks.zoned(zonedDateTimeCheck, ZoneId.systemDefault());
    }

    public static LocalDateTimeCheck localDateTimeWith() {
        return LocalDateTimeCheck.localDateTimeWith();
    }

    public static LocalDateCheck localDateWith() {
        return LocalDateCheck.localDateWith();
    }

    public static LocalTimeCheck localTimeWith() {
        return LocalTimeCheck.localTimeWith();
    }

    public static ZonedDateTimeCheck zonedDateTimeWith() {
        return ZonedDateTimeCheck.zonedDateTimeWith();
    }

    public static Check<String> parseLocalDateTime(Check<? super LocalDateTime> check) {
        return DateTimeChecks.parseLocalDateTime(DateTimeFormatter.ISO_LOCAL_DATE_TIME, check);
    }

    public static Check<String> parseLocalDateTime(String format, Check<? super LocalDateTime> check) {
        return DateTimeChecks.parseLocalDateTime(DateTimeFormatter.ofPattern(format), check);
    }

    public static Check<String> parseLocalDateTime(DateTimeFormatter format, Check<? super LocalDateTime> check) {
        return BasicChecks.compose("parse using " + format, string -> LocalDateTime.parse(string, format), check);
    }

    public static Check<String> parseZonedDateTime(Check<? super ZonedDateTime> check) {
        return DateTimeChecks.parseZonedDateTime(DateTimeFormatter.ISO_LOCAL_DATE_TIME, check);
    }

    public static Check<String> parseZonedDateTime(String format, Check<? super ZonedDateTime> check) {
        return DateTimeChecks.parseZonedDateTime(DateTimeFormatter.ofPattern(format), check);
    }

    public static Check<String> parseZonedDateTime(DateTimeFormatter format, Check<? super ZonedDateTime> check) {
        return BasicChecks.compose(string -> ZonedDateTime.parse(string, format), check);
    }
}

