/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import fluent.validation.result.TableAggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class AnyOrderCheck<D>
extends Check<Iterator<D>> {
    private final String elementName;
    private final ArrayList<Check<? super D>> checks;
    private final boolean prefix;
    private final boolean contains;
    private final boolean all;

    AnyOrderCheck(String elementName, Collection<Check<? super D>> checks, boolean full, boolean exact, boolean all) {
        this.elementName = elementName;
        this.checks = new ArrayList<Check<D>>(checks);
        this.prefix = !full;
        this.contains = !exact;
        this.all = all;
    }

    @Override
    public String toString() {
        return this.elementName + "s matching in any order " + this.checks;
    }

    @Override
    public Result evaluate(Iterator<D> data, ResultFactory factory) {
        if (data == null) {
            return factory.expectation(this, false);
        }
        HashSet<D> free = new HashSet<D>();
        TableAggregator<D> resultBuilder = factory.table(this, this.checks);
        HashMap graph = new HashMap();
        HashMap pairs = new HashMap();
        while (data.hasNext()) {
            D item = data.next();
            free.add(item);
            int c = resultBuilder.column(item);
            List matches = IntStream.range(0, this.checks.size()).filter(r -> resultBuilder.cell(r, c, this.checks.get(r).evaluate(item, factory)).passed()).mapToObj(this.checks::get).collect(Collectors.toList());
            graph.put(item, matches);
            AnyOrderCheck.updatePairs(free, pairs, graph);
            if (this.all || pairs.size() != this.checks.size()) continue;
            return this.contains || free.isEmpty() && (this.prefix || !data.hasNext()) ? resultBuilder.build("All checks satisfied", true) : resultBuilder.build("Unexpected " + this.elementName, false);
        }
        int unsatisfied = this.checks.size() - pairs.size();
        return unsatisfied == 0 && graph.values().stream().noneMatch(List::isEmpty) ? resultBuilder.build("All checks satisfied", true) : resultBuilder.build(unsatisfied + (unsatisfied == 1 ? " check" : " checks") + " not satisfied", false);
    }

    private static <A, B> void updatePairs(Set<A> free, Map<B, A> pairs, Map<A, List<B>> graph) {
        Edge path = AnyOrderCheck.findImprovedPath(free, pairs, graph);
        while (path != null) {
            while (path.prev.prev != path) {
                pairs.put(path.value, path.prev.value);
                path = path.prev.prev;
            }
            free.remove(path.prev.value);
            path = AnyOrderCheck.findImprovedPath(free, pairs, graph);
        }
    }

    private static <A, B> Edge<B, A> findImprovedPath(Set<A> free, Map<B, A> pairs, Map<A, List<B>> graph) {
        Queue queue = free.stream().map(x$0 -> new Edge(x$0)).collect(Collectors.toCollection(LinkedList::new));
        HashSet<Object> visited = new HashSet<Object>();
        while (!queue.isEmpty()) {
            Edge edge = (Edge)queue.poll();
            if (!visited.add(edge.value)) continue;
            for (B b : graph.get(edge.value)) {
                if (!pairs.containsKey(b)) {
                    return new Edge(edge, b);
                }
                queue.add(new Edge(new Edge(edge, b), pairs.get(b)));
            }
        }
        return null;
    }

    private static final class Edge<A, B> {
        private final Edge<B, A> prev;
        private final A value;

        private Edge(Edge<B, A> prev, A value) {
            this.prev = prev;
            this.value = value;
        }

        private Edge(A value) {
            this.prev = new Edge<Object, B>(this, null);
            this.value = value;
        }
    }
}

