/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.Dsl;
import fluent.dsl.Keyword;
import fluent.dsl.Name;
import fluent.dsl.Prefix;
import fluent.dsl.Suffix;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public final class FluentDslModel {
    private final String packageName;
    private final String className;
    private final String methodName;
    private final String parameterName;
    private final String parameterType;
    private final String modifiers;
    private ExecutableElement method;
    private final Map<String, FluentDslModel> followers = new LinkedHashMap<String, FluentDslModel>();

    public FluentDslModel(String packageName, String className, String methodName, String parameterName, String parameterType, String modifiers) {
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.modifiers = modifiers;
    }

    public String fullyQualifiedClassName() {
        return this.packageName() + "." + this.className();
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public String annotation() {
        return this.nonTerminal() ? "@Start(\"Fluent sentence must be finished.\")" : "@End";
    }

    public String returnType() {
        return this.nonTerminal() ? this.className : this.method.getReturnType().toString();
    }

    public String methodName() {
        return this.methodName;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterType() {
        return this.parameterType;
    }

    public Collection<FluentDslModel> followers() {
        return this.followers.values();
    }

    public boolean nonTerminal() {
        return this.method == null;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    private static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String uncap(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static FluentDslModel parameterNode(String className, String methodName, String returnType, String variableName) {
        return new FluentDslModel("", className, methodName, variableName, returnType, "public");
    }

    public static FluentDslModel classNode(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = dsl.packageName().isEmpty() ? element.getEnclosingElement().toString() : dsl.packageName();
        String typeName = element.getSimpleName().toString();
        String className = dsl.className().isEmpty() ? typeName + "Dsl" : dsl.className();
        String methodName = dsl.factoryMethod();
        return new FluentDslModel(packageName, className, methodName, "impl", typeName, "static");
    }

    public static FluentDslModel keywordNode(Element annotation) {
        String methodName = annotation.getSimpleName().toString();
        return new FluentDslModel("", FluentDslModel.cap(methodName), methodName, "", "", "public");
    }

    public String modifiers() {
        return this.modifiers;
    }

    public static FluentDslModel model(Element element) {
        FluentDslModel model = FluentDslModel.classNode(element);
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            FluentDslModel node = model;
            for (VariableElement variableElement : method.getParameters()) {
                String variableName;
                String returnType = variableElement.asType().toString();
                String rawType = returnType.split("<")[0];
                String methodName = variableName = variableElement.toString();
                String className = FluentDslModel.cap(methodName) + rawType.substring(rawType.lastIndexOf(46) + 1);
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    Element annotation = annotationMirror.getAnnotationType().asElement();
                    if (Objects.nonNull(annotation.getAnnotation(Keyword.class))) {
                        node = node.followers.computeIfAbsent(annotation.getSimpleName().toString(), key -> FluentDslModel.keywordNode(annotation));
                    }
                    if (Objects.nonNull(annotation.getAnnotation(Prefix.class))) {
                        methodName = annotation.getSimpleName() + FluentDslModel.cap(methodName);
                    }
                    if (!Objects.nonNull(annotation.getAnnotation(Name.class))) continue;
                    methodName = annotation.getSimpleName().toString();
                }
                String finalMethodName = methodName;
                node = node.followers.computeIfAbsent(className, key -> FluentDslModel.parameterNode(className, finalMethodName, returnType, variableName));
            }
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                Element annotation = annotationMirror.getAnnotationType().asElement();
                if (!Objects.nonNull(annotation.getAnnotation(Suffix.class))) continue;
                node = node.followers.computeIfAbsent(annotation.getSimpleName().toString(), key -> FluentDslModel.keywordNode(annotation));
            }
            node.method = method;
        }
        return model;
    }
}

