/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.processor.FluentDslModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class FluentDslGenerator {
    private static final String INDENTATION_LEVEL = "\t";
    private final PrintWriter writer;
    private final String indentation;

    private FluentDslGenerator(PrintWriter writer, String indentation) {
        this.writer = writer;
        this.indentation = indentation;
    }

    private FluentDslGenerator indent() {
        return new FluentDslGenerator(this.writer, this.indentation + INDENTATION_LEVEL);
    }

    private void generateReturnType(FluentDslModel model) {
        if (model.nonTerminal()) {
            this.writer.println();
            this.writer.println(this.indentation + "interface " + model.className() + " {");
            this.indent().generateContent(model);
            this.writer.println(this.indentation + "}");
        }
    }

    private void generateMethodImplementation(FluentDslModel model) {
        this.writer.println();
        this.writer.println(this.indentation + model.modifiers() + " " + model.returnType() + " " + model.methodName() + "(" + model.parameterType() + " " + model.parameterName() + ") {");
        this.indent().generateMethodBody(model);
        this.writer.println(this.indentation + "}");
    }

    private void generateAnonymousClass(FluentDslModel model) {
        this.writer.println(this.indentation + "return new " + model.className() + "() {");
        model.followers().forEach(this.indent()::generateMethodImplementation);
        this.writer.println(this.indentation + "};");
    }

    private void generateMethodBody(FluentDslModel model) {
        if (model.nonTerminal()) {
            this.generateAnonymousClass(model);
        } else {
            ExecutableElement method = model.getMethod();
            String methodName = (method.getModifiers().contains((Object)Modifier.STATIC) ? method.getEnclosingElement().toString() : "impl") + "." + method.getSimpleName();
            if (!"void".equals(method.getReturnType().toString())) {
                methodName = "return " + methodName;
            }
            this.writer.println(this.indentation + methodName + "(" + method.getParameters().stream().map(Object::toString).collect(Collectors.joining(", ")) + ");");
        }
    }

    private void generateMethod(FluentDslModel model) {
        this.writer.println(this.indentation + model.annotation() + " " + model.returnType() + " " + model.methodName() + "(" + model.parameterType() + " " + model.parameterName() + ");");
    }

    private void generateContent(FluentDslModel model) {
        model.followers().forEach(this::generateMethod);
        model.followers().forEach(this::generateReturnType);
    }

    private void generateRoot(FluentDslModel model) {
        this.writer.println("package " + model.packageName() + ";");
        this.writer.println();
        this.writer.println("import javax.annotation.Generated;");
        this.writer.println("import fluent.api.Start;");
        this.writer.println("import fluent.api.End;");
        this.writer.println();
        this.writer.println("@Generated(\"DSL class generated from " + model.returnType() + "\")");
        this.writer.println("public interface " + model.className() + " {");
        this.writer.println();
        this.indent().generateMethodImplementation(model);
        this.indent().generateContent(model);
        this.writer.println("}");
    }

    public static void generateFile(Filer filer, FluentDslModel model) {
        try (PrintWriter writer = new PrintWriter(filer.createSourceFile(model.fullyQualifiedClassName(), new Element[0]).openWriter());){
            new FluentDslGenerator(writer, "").generateRoot(model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

