/*
 * BSD 2-Clause License
 *
 * Copyright (c) 2019, Ondrej Fischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 *  Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package fluent.dsl;

public class Bdd<A, V> {

    private final A actions;
    private final V verifications;

    protected Bdd(A actions, V verifications) {
        this.actions = actions;
        this.verifications = verifications;
    }



    public static <A, V> Bdd<A, V> bdd(A actions, V verifications) {
        return new Bdd<>(actions, verifications);
    }



    public static <A> A When(Bdd<A, ?> actor) {
        return actor.actions;
    }

    public static <A> A and(Bdd<A, ?> actor) {
        return actor.actions;
    }
    public static <A> A Given(Bdd<A, ?> actor) {
        return actor.actions;
    }



    public static <V> V then(Bdd<?, V> actor) {
        return actor.verifications;
    }
    public static <V> V andThen(Bdd<?, V> actor) {
        return actor.verifications;
    }


    public static <A> A When(A actor) {
        return actor;
    }

    public static <A> A and(A actor) {
        return actor;
    }
    public static <A> A Given(A actor) {
        return actor;
    }



    public static <V> V then(V actor) {
        return actor;
    }
    public static <V> V andThen(V actor) {
        return actor;
    }

}
