/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.Dsl;
import fluent.dsl.Keyword;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public final class NodeModel {
    public static final String Actions = "Actions";
    public static final String Verifications = "Verifications";
    private final String packageName;
    private final String className;
    private final String methodName;
    private final String parameterName;
    private final String parameterType;
    private ExecutableElement method;
    private final Map<Object, NodeModel> followers = new LinkedHashMap<Object, NodeModel>();

    public NodeModel(String packageName, String className, String methodName, String parameterName, String parameterType, ExecutableElement method) {
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.method = method;
    }

    public String fullyQualifiedClassName() {
        return this.packageName() + "." + this.className();
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public String returnType() {
        return this.nonTerminal() ? this.className : this.method.getReturnType().toString();
    }

    public String methodName() {
        return this.methodName;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterType() {
        return this.parameterType;
    }

    public Collection<NodeModel> followers() {
        return this.followers.values();
    }

    public boolean nonTerminal() {
        return this.method == null;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    private static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String uncap(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static NodeModel parameterNode(VariableElement element) {
        String variableName = element.getSimpleName().toString();
        String capName = NodeModel.cap(variableName);
        String returnType = element.asType().toString();
        return new NodeModel("", capName + returnType.substring(returnType.lastIndexOf(46) + 1) + Integer.toHexString(element.hashCode()), NodeModel.uncap(element.getAnnotationMirrors().stream().filter(a -> Objects.nonNull(a.getAnnotationType().asElement().getAnnotation(Keyword.class))).map(a -> NodeModel.cap(a.getAnnotationType().asElement().getSimpleName().toString())).collect(Collectors.joining()) + capName), variableName, returnType, null);
    }

    public static NodeModel classNode(Element element) {
        Dsl dsl = element.getAnnotation(Dsl.class);
        String packageName = dsl.packageName().isEmpty() ? element.getEnclosingElement().toString() : dsl.packageName();
        String typeName = element.getSimpleName().toString();
        String className = dsl.className().isEmpty() ? typeName + (Object)((Object)dsl.value()) : dsl.className();
        String methodName = dsl.factoryMethod().isEmpty() ? "create" : dsl.factoryMethod();
        return new NodeModel(packageName, className, methodName, className, typeName, null);
    }

    public static NodeModel keywordNode(AnnotationMirror annotationMirror) {
        Element annotation = annotationMirror.getAnnotationType().asElement();
        Keyword keyword = annotation.getAnnotation(Keyword.class);
        String methodName = keyword.value().length() > 0 ? keyword.value() : annotation.getSimpleName().toString();
        return new NodeModel("", methodName + Integer.toHexString(annotation.hashCode()), methodName, "", "", null);
    }

    public static NodeModel groupModel(String group) {
        return new NodeModel("", group, group, group, group, null);
    }

    public static NodeModel createBddModel(Element element) {
        NodeModel model = NodeModel.classNode(element);
        model.followers.put(Actions, NodeModel.groupModel(Actions));
        model.followers.put(Verifications, NodeModel.groupModel(Verifications));
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            NodeModel node = model.followers.get(method.getSimpleName().toString().contains("verification") ? Verifications : Actions);
            for (VariableElement variableElement : method.getParameters()) {
                node = node.followers.computeIfAbsent(variableElement, key -> NodeModel.parameterNode(parameter));
            }
            node.method = method;
        }
        return model;
    }

    public static NodeModel createDirectDslModel(Element element) {
        NodeModel model = NodeModel.classNode(element);
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            NodeModel node = model;
            for (VariableElement variableElement : method.getParameters()) {
                node = node.followers.computeIfAbsent(variableElement, key -> NodeModel.parameterNode(parameter));
            }
            node.method = method;
        }
        return model;
    }

    public NodeModel follower(String actions) {
        return this.followers.get(actions);
    }
}

