/*
 * Decompiled with CFR 0.152.
 */
package fluent.dsl.processor;

import fluent.dsl.processor.NodeModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;

public final class FluentDslGenerator {
    private static final String INDENT = "\t";
    private final PrintWriter writer;

    private FluentDslGenerator(PrintWriter writer) {
        this.writer = writer;
    }

    private void generate(String prefix, NodeModel model) {
        model.followers().forEach(methodModel -> this.generateReturnType(prefix, (NodeModel)methodModel));
        model.followers().forEach(methodModel -> this.generateMethod(prefix, (NodeModel)methodModel));
    }

    private void generateReturnType(String prefix, NodeModel model) {
        if (model.nonTerminal()) {
            this.writer.println();
            this.writer.println(prefix + "interface " + model.className() + " {");
            this.generate(prefix + INDENT, model);
            this.writer.println();
            this.writer.println(prefix + "}");
        }
    }

    private void generateMethodImplementation(String prefix, NodeModel model) {
        this.writer.println();
        this.writer.println(prefix + "public " + model.returnType() + " " + model.methodName() + "(" + model.parameterType() + " " + model.parameterName() + ") {");
        this.generateMethodBody(prefix + INDENT, model);
        this.writer.println(prefix + "}");
    }

    private void generateAnonymousClass(String prefix, NodeModel model, String suffix) {
        this.writer.println("new " + model.className() + "() {");
        model.followers().forEach(methodModel -> this.generateMethodImplementation(prefix + INDENT, (NodeModel)methodModel));
        this.writer.println();
        this.writer.println(prefix + "}" + suffix);
    }

    private void generateMethodBody(String prefix, NodeModel model) {
        if (model.nonTerminal()) {
            this.writer.println();
            this.writer.print(prefix + "return ");
            this.generateAnonymousClass(prefix, model, ";");
        } else {
            this.writer.println(prefix + "impl." + model.getMethod().getSimpleName() + "(" + model.getMethod().getParameters().stream().map(Object::toString).collect(Collectors.joining(", ")) + ");");
        }
    }

    private void generateMethod(String prefix, NodeModel model) {
        this.writer.println();
        this.writer.println(prefix + model.returnType() + " " + model.methodName() + "(" + model.parameterType() + " arg);");
    }

    public static void generateBdd(Filer filer, NodeModel model) {
        try (Writer writer = filer.createSourceFile(model.fullyQualifiedClassName(), new Element[0]).openWriter();){
            PrintWriter printWriter = new PrintWriter(writer);
            FluentDslGenerator generator = new FluentDslGenerator(printWriter);
            printWriter.println("package " + model.packageName() + ";");
            printWriter.println();
            printWriter.println("public final class " + model.className() + " {");
            printWriter.println();
            printWriter.println("\tpublic static final class Dsl extends fluent.dsl.Bdd<Actions, Verifications> {");
            printWriter.println("\t\tprivate Dsl(Actions actions, Verifications verifications) {super(actions, verifications);}");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tpublic static Dsl " + model.methodName() + "(" + model.parameterType() + " impl) {");
            printWriter.println("\t\treturn new Dsl(");
            printWriter.print("\t\t\t");
            generator.generateAnonymousClass("\t\t\t", model.follower("Actions"), ",");
            printWriter.print("\t\t\t");
            generator.generateAnonymousClass("\t\t\t", model.follower("Verifications"), "");
            printWriter.println("\t\t);");
            printWriter.println("\t}");
            model.followers().forEach(methodModel -> generator.generateReturnType(INDENT, (NodeModel)methodModel));
            printWriter.println();
            printWriter.println("}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateDirectDsl(Filer filer, NodeModel model) {
        try (Writer writer = filer.createSourceFile(model.fullyQualifiedClassName(), new Element[0]).openWriter();){
            PrintWriter printWriter = new PrintWriter(writer);
            FluentDslGenerator generator = new FluentDslGenerator(printWriter);
            printWriter.println("package " + model.packageName() + ";");
            printWriter.println();
            printWriter.println("public interface " + model.className() + " {");
            printWriter.println();
            printWriter.println("\tpublic static " + model.className() + " " + model.methodName() + "(" + model.parameterType() + " impl) {");
            printWriter.print("\t\treturn ");
            generator.generateAnonymousClass("\t\t", model, ";");
            printWriter.println("\t}");
            printWriter.println();
            generator.generate(INDENT, model);
            printWriter.println();
            printWriter.println("}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

