/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.processor;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import fluent.api.generator.Parameter;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TemplateModel;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;

public class ParameterScanner
extends TreePathScanner<Void, TemplateModel> {
    private final Trees trees;
    private final ModelFactory factory;

    public ParameterScanner(Trees trees, ModelFactory factory) {
        this.trees = trees;
        this.factory = factory;
    }

    public void scan(Element e, TemplateModel model) {
        TreePath path = this.trees.getPath(e);
        if (Objects.nonNull(path)) {
            this.scan(path, model);
        }
    }

    private void tryAddParameter(Element annotatedElement, Stream<Element> annotationTypes, final TemplateModel model) {
        annotationTypes.forEach(annotationType -> {
            Parameter parameter = annotationType.getAnnotation(Parameter.class);
            if (Objects.nonNull(parameter)) {
                annotatedElement.accept(new ElementVisitor<Void, String>(){

                    private Void add(String s, Object o) {
                        model.with(s, o);
                        return null;
                    }

                    @Override
                    public Void visit(Element e, String s) {
                        return null;
                    }

                    @Override
                    public Void visit(Element e) {
                        return null;
                    }

                    @Override
                    public Void visitPackage(PackageElement e, String s) {
                        return null;
                    }

                    @Override
                    public Void visitType(TypeElement e, String s) {
                        return this.add(s, ParameterScanner.this.factory.type(e.asType()));
                    }

                    @Override
                    public Void visitVariable(VariableElement e, String s) {
                        return this.add(s, ParameterScanner.this.factory.variable(e));
                    }

                    @Override
                    public Void visitExecutable(ExecutableElement e, String s) {
                        return this.add(s, ParameterScanner.this.factory.method(e));
                    }

                    @Override
                    public Void visitTypeParameter(TypeParameterElement e, String s) {
                        return this.add(s, ParameterScanner.this.factory.type(e.asType()));
                    }

                    @Override
                    public Void visitUnknown(Element e, String s) {
                        return null;
                    }
                }, annotationType.getSimpleName().toString());
            }
        });
    }

    private void tryAddParameter(Element element, TemplateModel model) {
        this.tryAddParameter(element, element.getAnnotationMirrors().stream().map(annotation -> annotation.getAnnotationType().asElement()), model);
    }

    private Element asElement(Tree tree) {
        return this.trees.getElement(this.trees.getPath(this.getCurrentPath().getCompilationUnit(), tree));
    }

    @Override
    public Void visitMethod(MethodTree tree, TemplateModel templateModel) {
        this.tryAddParameter(this.trees.getElement(this.getCurrentPath()), templateModel);
        return (Void)super.visitMethod(tree, templateModel);
    }

    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree tree, final TemplateModel templateModel) {
        final Stream<Element> annotationTypes = tree.getAnnotations().stream().map(annotation -> this.asElement(annotation.getAnnotationType()));
        tree.getUnderlyingType().accept(new SimpleTreeVisitor<Void, Void>(){

            @Override
            public Void visitWildcard(WildcardTree wildcardTree, Void aVoid) {
                ParameterScanner.this.tryAddParameter(ParameterScanner.this.asElement(wildcardTree.getBound()), annotationTypes, templateModel);
                return null;
            }

            @Override
            protected Void defaultAction(Tree tree, Void aVoid) {
                ParameterScanner.this.tryAddParameter(ParameterScanner.this.asElement(tree), annotationTypes, templateModel);
                return null;
            }
        }, null);
        return (Void)super.visitAnnotatedType(tree, templateModel);
    }

    @Override
    public Void visitVariable(VariableTree tree, TemplateModel templateModel) {
        this.tryAddParameter(this.trees.getElement(this.getCurrentPath()), templateModel);
        return (Void)super.visitVariable(tree, templateModel);
    }

    @Override
    public Void visitClass(ClassTree classTree, TemplateModel templateModel) {
        this.tryAddParameter(this.trees.getElement(this.getCurrentPath()), templateModel);
        return (Void)super.visitClass(classTree, templateModel);
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree typeParameterTree, TemplateModel templateModel) {
        this.tryAddParameter(this.trees.getElement(this.getCurrentPath()), templateModel);
        return (Void)super.visitTypeParameter(typeParameterTree, templateModel);
    }
}

