/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.VarModel;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class VarModelImpl
implements VarModel {
    private final VariableElement element;
    private final TypeMirror type;
    private final ModelFactory factory;

    public VarModelImpl(VariableElement element, TypeMirror type, ModelFactory factory) {
        this.element = element;
        this.type = type;
        this.factory = factory;
    }

    @Override
    public String name() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public TypeModel type() {
        return this.factory.type(this.type);
    }

    @Override
    public MethodModel method() {
        if (this.element.getKind() == ElementKind.PARAMETER) {
            return this.factory.method((ExecutableElement)this.element.getEnclosingElement());
        }
        return null;
    }

    @Override
    public String packageName() {
        return this.type().packageName();
    }

    @Override
    public boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public Map<String, Map<String, Object>> annotations() {
        return this.element.getAnnotationMirrors().stream().collect(Collectors.toMap(a -> a.getAnnotationType().asElement().getSimpleName().toString(), a -> a.getElementValues().entrySet().stream().collect(Collectors.toMap(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString(), e -> this.factory.annotationValue((AnnotationValue)e.getValue())))));
    }

    public String toString() {
        return this.name();
    }
}

