/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.VarModel;
import fluent.api.generator.model.impl.AbstractTypeModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class DeclaredTypeModel
extends AbstractTypeModel {
    private final DeclaredType type;
    private final TypeElement element;
    private final ModelFactory factory;
    private final Elements elements;
    private final Types types;

    DeclaredTypeModel(DeclaredType type, ModelFactory factory, Elements elements, Types types) {
        this.type = type;
        this.element = (TypeElement)type.asElement();
        this.factory = factory;
        this.elements = elements;
        this.types = types;
    }

    @Override
    public String wrapper() {
        return this.toString();
    }

    @Override
    public String simpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public String packageName() {
        return this.element.getEnclosingElement().toString();
    }

    @Override
    public List<MethodModel> methods() {
        return this.elements.getAllMembers(this.element).stream().filter(element -> element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.STATIC) && element instanceof ExecutableElement).map(ExecutableElement.class::cast).map(method -> this.factory.asMemberOf(this.type, (ExecutableElement)method)).collect(Collectors.toList());
    }

    @Override
    public List<MethodModel> declaredMethods() {
        return this.element.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).map(method -> this.factory.asMemberOf(this.type, (ExecutableElement)method)).collect(Collectors.toList());
    }

    @Override
    public List<VarModel> fields() {
        return this.elements.getAllMembers(this.element).stream().filter(element -> element.getKind() == ElementKind.FIELD).map(VariableElement.class::cast).map(method -> this.factory.asMemberOf(this.type, (VariableElement)method)).collect(Collectors.toList());
    }

    @Override
    public List<TypeModel> interfaces() {
        return this.element.getInterfaces().stream().map(this.factory::type).collect(Collectors.toList());
    }

    @Override
    public TypeModel superClass() {
        return this.factory.type(this.element.getSuperclass());
    }

    @Override
    public String raw() {
        return this.element.toString();
    }

    @Override
    public List<TypeModel> parameters() {
        return this.type.getTypeArguments().stream().map(this.factory::type).collect(Collectors.toList());
    }

    @Override
    public boolean isSimple() {
        return this.isEnum() || "java.lang".equals(this.packageName());
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public boolean hasDefaultConstructor() {
        return this.elements.getAllMembers(this.element).stream().anyMatch(member -> member.getKind() == ElementKind.CONSTRUCTOR && member.getModifiers().contains((Object)Modifier.PUBLIC) && ((ExecutableElement)member).getParameters().isEmpty());
    }

    @Override
    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isSubclassOf(DeclaredType parent) {
        return this.types.isAssignable(this.type, parent);
    }

    @Override
    public boolean isEnum() {
        return this.element.getKind() == ElementKind.ENUM;
    }
}

