/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.processor;

import fluent.api.generator.Templates;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TemplateModel;
import fluent.api.generator.processor.DefaultValueVisitor;
import fluent.api.generator.processor.ParameterScanner;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;

class GeneratingVisitor
implements ElementVisitor<Void, TypeElement> {
    private static final Pattern PACKAGE = Pattern.compile("package\\s+([^;]+)\\s*;");
    private static final Pattern CLASS = Pattern.compile("(class|interface)\\s+(\\w+)");
    private final Filer filer;
    private final Set<String> generated = new HashSet<String>();
    private final ModelFactory factory;
    private final ParameterScanner parametersScanner;

    GeneratingVisitor(Filer filer, ModelFactory factory, ParameterScanner parametersScanner) {
        this.filer = filer;
        this.factory = factory;
        this.parametersScanner = parametersScanner;
    }

    @Override
    public Void visit(Element e, TypeElement annotation) {
        return null;
    }

    @Override
    public Void visit(Element e) {
        return null;
    }

    @Override
    public Void visitPackage(PackageElement e, TypeElement annotation) {
        return null;
    }

    @Override
    public Void visitType(TypeElement e, TypeElement annotation) {
        return this.render(this.factory.model().with("type", this.factory.type(e.asType())), e, annotation);
    }

    @Override
    public Void visitVariable(VariableElement e, TypeElement annotation) {
        return this.render(this.factory.model().with("var", this.factory.variable(e)), e, annotation);
    }

    @Override
    public Void visitExecutable(ExecutableElement e, TypeElement annotation) {
        return this.render(this.factory.model().with("method", this.factory.method(e)), e, annotation);
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, TypeElement annotation) {
        return null;
    }

    @Override
    public Void visitUnknown(Element e, TypeElement annotation) {
        return null;
    }

    private Void render(TemplateModel model, Element annotatedElement, TypeElement annotation) {
        this.parametersScanner.scan(annotatedElement, model);
        annotation.getEnclosedElements().forEach(new DefaultValueVisitor(method -> model.with(method.getSimpleName().toString(), method.getDefaultValue().getValue())));
        annotatedElement.getAnnotationMirrors().stream().filter(mirror -> mirror.getAnnotationType().asElement().equals(annotation)).forEach(mirror -> mirror.getElementValues().forEach((name, value) -> model.with(name.getSimpleName().toString(), value.getValue())));
        for (String path : annotation.getAnnotation(Templates.class).value()) {
            String sourcePath;
            String source = model.render(path);
            Matcher packageName = PACKAGE.matcher(source);
            Matcher className = CLASS.matcher(source);
            if (!packageName.find() || !className.find() || !this.generated.add(sourcePath = packageName.group(1) + "." + className.group(2))) continue;
            try (Writer output = this.filer.createSourceFile(sourcePath, new Element[0]).openWriter();){
                output.append(source);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

