/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TemplateModel;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.VarModel;
import fluent.api.generator.model.impl.ArrayTypeModel;
import fluent.api.generator.model.impl.DeclaredTypeModel;
import fluent.api.generator.model.impl.ExecutableModel;
import fluent.api.generator.model.impl.JtwigTemplateModel;
import fluent.api.generator.model.impl.NoTypeModel;
import fluent.api.generator.model.impl.PrimitiveTypeModel;
import fluent.api.generator.model.impl.TypeVariableModel;
import fluent.api.generator.model.impl.VarModelImpl;
import javax.annotation.processing.Filer;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ModelTypeFactory
implements ModelFactory {
    private final Types types;
    private final Elements elements;
    private final Filer filer;

    public ModelTypeFactory(Types types, Elements elements, Filer filer) {
        this.types = types;
        this.elements = elements;
        this.filer = filer;
    }

    @Override
    public TypeModel asMemberOf(TypeElement declaring, TypeElement member) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public VarModel asMemberOf(DeclaredType declaring, VariableElement member) {
        return this.variable(member, this.types.asMemberOf(declaring, member));
    }

    @Override
    public MethodModel asMemberOf(DeclaredType declaring, ExecutableElement member) {
        return this.method(member, (ExecutableType)this.types.asMemberOf(declaring, member));
    }

    @Override
    public MethodModel method(ExecutableElement executableElement, ExecutableType type) {
        return new ExecutableModel(executableElement, type, this);
    }

    @Override
    public VarModel variable(VariableElement variableElement, TypeMirror type) {
        return new VarModelImpl(variableElement, type, this);
    }

    @Override
    public TypeModel type(TypeMirror typeMirror) {
        return typeMirror.accept(new TypeVisitor<TypeModel, ModelFactory>(){

            @Override
            public TypeModel visit(TypeMirror type, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visit(TypeMirror type) {
                return null;
            }

            @Override
            public TypeModel visitPrimitive(PrimitiveType type, ModelFactory factory) {
                return new PrimitiveTypeModel(type);
            }

            @Override
            public TypeModel visitNull(NullType t, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitArray(ArrayType type, ModelFactory factory) {
                return new ArrayTypeModel(type, factory);
            }

            @Override
            public TypeModel visitDeclared(DeclaredType type, ModelFactory factory) {
                return new DeclaredTypeModel(type, factory, ModelTypeFactory.this.elements, ModelTypeFactory.this.types);
            }

            @Override
            public TypeModel visitError(ErrorType type, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitTypeVariable(TypeVariable type, ModelFactory factory) {
                return new TypeVariableModel(type);
            }

            @Override
            public TypeModel visitWildcard(WildcardType t, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitExecutable(ExecutableType t, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitNoType(NoType type, ModelFactory factory) {
                return new NoTypeModel(type);
            }

            @Override
            public TypeModel visitUnknown(TypeMirror t, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitUnion(UnionType t, ModelFactory factory) {
                return null;
            }

            @Override
            public TypeModel visitIntersection(IntersectionType t, ModelFactory factory) {
                return null;
            }
        }, this);
    }

    @Override
    public TemplateModel model() {
        return new JtwigTemplateModel(this.filer);
    }
}

