/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.processor;

import com.sun.source.util.Trees;
import fluent.api.generator.Templates;
import fluent.api.generator.TypeFilter;
import fluent.api.generator.model.impl.ModelTypeFactory;
import fluent.api.generator.processor.GeneratingVisitor;
import fluent.api.generator.processor.ParameterScanner;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
public class GeneratingProcessor
extends AbstractProcessor {
    private static final Predicate<Element> defaultFilter = element -> true;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessingEnvironment processingEnv = this.jbUnwrap(this.processingEnv);
        Filer filer = processingEnv.getFiler();
        ModelTypeFactory factory = new ModelTypeFactory(processingEnv.getTypeUtils(), processingEnv.getElementUtils(), filer);
        ParameterScanner parameterScanner = new ParameterScanner(Trees.instance(processingEnv), factory);
        for (TypeElement typeElement : annotations) {
            List templateAnnotations = Stream.concat(Stream.of(typeElement), typeElement.getAnnotationMirrors().stream().map(m -> m.getAnnotationType().asElement())).filter((? super T a) -> Objects.nonNull(a.getAnnotation(Templates.class))).collect(Collectors.toList());
            if (templateAnnotations.isEmpty()) continue;
            roundEnv.getElementsAnnotatedWith(typeElement).forEach(element -> templateAnnotations.forEach(templateAnnotation -> {
                if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) {
                    Target templateTargets = templateAnnotation.getAnnotation(Target.class);
                    if (templateTargets != null) {
                        Target elementTargets = element.getAnnotation(Target.class);
                        Set collect = Stream.of(templateTargets.value()).collect(Collectors.toSet());
                        if (elementTargets == null || !collect.containsAll(Stream.of(elementTargets.value()).collect(Collectors.toSet()))) {
                            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid use of annotation: " + annotation + "! When applied on annotation, it must restrict usage to " + templateTargets + ". But annotation " + element + " allows " + (elementTargets == null ? "any target." : elementTargets), (Element)element);
                        }
                    }
                } else {
                    Predicate<Element> predicate = this.filter(templateAnnotation.getAnnotation(TypeFilter.class));
                    if (predicate.test((Element)element)) {
                        GeneratingVisitor visitor = new GeneratingVisitor(filer, factory, parameterScanner, annotation == templateAnnotation ? element : annotation);
                        element.accept(visitor, (TypeElement)templateAnnotation);
                    } else {
                        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid use of annotation: " + annotation + "! It can be applied only on " + predicate, (Element)element);
                    }
                }
            }));
        }
        return false;
    }

    private ProcessingEnvironment jbUnwrap(ProcessingEnvironment wrappedEnv) {
        ProcessingEnvironment unwrapped = null;
        try {
            Class<?> apiWrappers = wrappedEnv.getClass().getClassLoader().loadClass("org.jetbrains.jps.javac.APIWrappers");
            Method unwrapMethod = apiWrappers.getDeclaredMethod("unwrap", Class.class, Object.class);
            unwrapped = (ProcessingEnvironment)unwrapMethod.invoke(null, ProcessingEnvironment.class, wrappedEnv);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unwrapped != null ? unwrapped : wrappedEnv;
    }

    private Predicate<Element> filter(TypeFilter filter) {
        return Objects.isNull(filter) ? defaultFilter : new TypeFilterPredicate(filter.value());
    }

    private static final class TypeFilterPredicate
    implements Predicate<Element> {
        private final String pattern;

        private TypeFilterPredicate(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean test(Element element) {
            return element.asType().toString().matches(this.pattern);
        }

        public String toString() {
            return "type matching: " + this.pattern;
        }
    }
}

