/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.processor;

import com.sun.source.util.Trees;
import fluent.api.generator.Templates;
import fluent.api.generator.TypeFilter;
import fluent.api.generator.model.impl.ModelTypeFactory;
import fluent.api.generator.processor.GeneratingVisitor;
import fluent.api.generator.processor.ParameterScanner;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GeneratingProcessor
extends AbstractProcessor {
    private static final Predicate<Element> defaultFilter = element -> true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        ModelTypeFactory factory = new ModelTypeFactory(this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), filer);
        ParameterScanner parameterScanner = new ParameterScanner(Trees.instance(this.processingEnv), factory);
        GeneratingVisitor visitor = new GeneratingVisitor(filer, factory, parameterScanner);
        for (TypeElement typeElement : annotations) {
            Templates templatesAnnotation = typeElement.getAnnotation(Templates.class);
            if (!Objects.nonNull(templatesAnnotation)) continue;
            Predicate<Element> predicate = this.filter(typeElement.getAnnotation(TypeFilter.class));
            roundEnv.getElementsAnnotatedWith(typeElement).forEach(element -> {
                if (predicate.test((Element)element)) {
                    element.accept(visitor, annotation);
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid use of annotation: " + annotation + "! It can be applied only on " + predicate, (Element)element);
                }
            });
        }
        return false;
    }

    private Predicate<Element> filter(TypeFilter filter) {
        return Objects.isNull(filter) ? defaultFilter : new TypeFilterPredicate(filter.value());
    }

    private static final class TypeFilterPredicate
    implements Predicate<Element> {
        private final String pattern;

        private TypeFilterPredicate(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean test(Element element) {
            return element.asType().toString().matches(this.pattern);
        }

        public String toString() {
            return "type matching: " + this.pattern;
        }
    }
}

