/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.VarModel;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class VarModelImpl
implements VarModel {
    private final VariableElement element;
    private final TypeMirror type;
    private final ModelFactory factory;

    public VarModelImpl(VariableElement element, TypeMirror type, ModelFactory factory) {
        this.element = element;
        this.type = type;
        this.factory = factory;
    }

    @Override
    public String name() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public TypeModel type() {
        return this.factory.type(this.type);
    }

    @Override
    public MethodModel method() {
        if (this.element.getKind() == ElementKind.PARAMETER) {
            return this.factory.method((ExecutableElement)this.element.getEnclosingElement());
        }
        return null;
    }

    @Override
    public String packageName() {
        return this.type().packageName();
    }

    @Override
    public boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isFinal() {
        return this.element.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public Map<String, Map<String, Object>> annotations() {
        return this.factory.annotations(this.element);
    }

    public String toString() {
        return this.name();
    }
}

