/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.ElementModel;
import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.VarModel;
import fluent.api.generator.model.impl.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ExecutableType;

public class ExecutableModel
implements MethodModel {
    private final ExecutableElement element;
    private final ExecutableType type;
    private final ModelFactory factory;

    public ExecutableModel(ExecutableElement element, ExecutableType type, ModelFactory factory) {
        this.element = element;
        this.type = type;
        this.factory = factory;
    }

    @Override
    public String name() {
        return this.element.getSimpleName().toString();
    }

    public String toString() {
        return this.name();
    }

    @Override
    public TypeModel type() {
        return this.factory.type(this.type.getReturnType());
    }

    @Override
    public String propertyName() {
        return TypeUtils.propertyName(this.name());
    }

    @Override
    public String toProperty(String regexPrefix, String group) {
        String result = this.name().replaceFirst(regexPrefix, group);
        return Character.toLowerCase(result.charAt(0)) + result.substring(1);
    }

    @Override
    public List<VarModel> parameters() {
        ArrayList<VarModel> result = new ArrayList<VarModel>(this.type.getParameterTypes().size());
        for (int i = 0; i < this.type.getParameterTypes().size(); ++i) {
            result.add(this.factory.variable(this.element.getParameters().get(i), this.type.getParameterTypes().get(i)));
        }
        return result;
    }

    @Override
    public List<TypeModel> typeVariables() {
        return this.type.getTypeVariables().stream().map(this.factory::type).collect(Collectors.toList());
    }

    @Override
    public TypeModel declaringClass() {
        return this.factory.type(this.element.getEnclosingElement().asType());
    }

    @Override
    public boolean isConstructor() {
        return this.element.getKind() == ElementKind.CONSTRUCTOR;
    }

    @Override
    public List<TypeModel> parameterTypes() {
        return this.parameters().stream().map(ElementModel::type).collect(Collectors.toList());
    }

    @Override
    public boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isFinal() {
        return this.element.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public Map<String, Map<String, Object>> annotations() {
        return this.factory.annotations(this.element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableModel that = (ExecutableModel)o;
        return Objects.equals(this.element, that.element) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.type);
    }
}

