/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.model.impl;

import fluent.api.generator.model.MethodModel;
import fluent.api.generator.model.ModelFactory;
import fluent.api.generator.model.TypeModel;
import fluent.api.generator.model.impl.AbstractTypeModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

class DeclaredTypeModel
extends AbstractTypeModel {
    private final DeclaredType type;
    private final TypeElement element;
    private final ModelFactory factory;

    DeclaredTypeModel(DeclaredType type, ModelFactory factory) {
        this.type = type;
        this.element = (TypeElement)type.asElement();
        this.factory = factory;
    }

    @Override
    public String wrapper() {
        return this.toString();
    }

    @Override
    public String simpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public String packageName() {
        return this.element.getEnclosingElement().toString();
    }

    @Override
    public List<MethodModel> methods() {
        return this.element.getEnclosedElements().stream().filter(element -> element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.STATIC) && element instanceof ExecutableElement).map(ExecutableElement.class::cast).map(method -> this.factory.asMemberOf(this.type, (ExecutableElement)method)).collect(Collectors.toList());
    }

    @Override
    public List<TypeModel> interfaces() {
        return this.element.getInterfaces().stream().map(this.factory::type).collect(Collectors.toList());
    }

    @Override
    public TypeModel superClass() {
        return this.factory.type(this.element.getSuperclass());
    }

    @Override
    public List<TypeModel> parameters() {
        return this.type.getTypeArguments().stream().map(this.factory::type).collect(Collectors.toList());
    }

    @Override
    public boolean isSimple() {
        return this.element.getKind() == ElementKind.ENUM || "java.lang".equals(this.packageName());
    }

    @Override
    public String toString() {
        return this.type.toString();
    }
}

