/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.setters;

import fluent.api.generator.setters.GenericPojoFixture;
import fluent.api.generator.setters.GenericPojoFixtureCreator;
import fluent.api.generator.setters.PojoFixture;
import fluent.api.generator.setters.PojoFixtureBuilder;
import fluent.api.generator.setters.simple.GenericPojoFixtureBuilder;
import java.time.LocalDate;
import java.util.LinkedList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleFluentBuilderTest {
    @Test
    public void testSimplePojoBuilder() {
        LocalDate now = LocalDate.now();
        LinkedList<String> list = new LinkedList<String>();
        PojoFixture fixture = PojoFixtureBuilder.pojo().anInt(5).aLong(6L).aString("a").aLocalDate(now).aList(list).build();
        Assert.assertEquals((int)fixture.getAnInt(), (int)5);
        Assert.assertEquals((Object)fixture.getaLong(), (Object)6L);
        Assert.assertEquals((String)fixture.getaString(), (String)"a");
        Assert.assertEquals((Object)fixture.getaLocalDate(), (Object)now);
        Assert.assertEquals(fixture.getaList(), list);
    }

    @Test
    public void testSimpleStringPojoBuilder() {
        LocalDate now = LocalDate.now();
        LinkedList<String> list = new LinkedList<String>();
        GenericPojoFixture<String> fixture = new GenericPojoFixtureBuilder().anInt(5).aLong(6L).aString("a").aLocalDate(now).aList(list).aT("B").build();
        Assert.assertEquals((int)fixture.getAnInt(), (int)5);
        Assert.assertEquals((Object)fixture.getaLong(), (Object)6L);
        Assert.assertEquals((String)fixture.getaString(), (String)"a");
        Assert.assertEquals((Object)fixture.getaLocalDate(), (Object)now);
        Assert.assertEquals(fixture.getaList(), list);
        Assert.assertEquals((String)fixture.getaT(), (String)"B");
    }

    @Test
    public void testSimpleGenericPojoBuilder() {
        LocalDate now = LocalDate.now();
        LinkedList<String> list = new LinkedList<String>();
        GenericPojoFixture<Integer> fixture = new GenericPojoFixtureCreator().anInt(5).aLong(6L).aString("a").aLocalDate(now).aList(list).aT(8).create();
        Assert.assertEquals((int)fixture.getAnInt(), (int)5);
        Assert.assertEquals((Object)fixture.getaLong(), (Object)6L);
        Assert.assertEquals((String)fixture.getaString(), (String)"a");
        Assert.assertEquals((Object)fixture.getaLocalDate(), (Object)now);
        Assert.assertEquals(fixture.getaList(), list);
        Assert.assertEquals((Object)fixture.getaT(), (Object)8);
    }
}

