/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.sender;

import fluent.api.generator.TestBase;
import fluent.api.generator.sender.FixtureBean;
import fluent.api.generator.sender.FixtureBeanLocator;
import fluent.api.generator.sender.FixtureBeanSender;
import fluent.api.generator.sender.FixtureBeanSimpleAccepter;
import fluent.api.generator.sender.SenderFixtureClass;
import fluent.api.generator.sender.SenderFixtureInterface;
import fluent.api.generator.sender.impl.FixtureBeanAccepterImpl;
import java.util.List;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SenderTest
extends TestBase {
    @Mock
    private FixtureBean fixtureBean;
    @Mock
    private SenderFixtureInterface fixtureInterface;
    @Mock
    private List<FixtureBean> list;

    @Test
    public void testSimpleSender() {
        new FixtureBeanSimpleAccepter(this.fixtureInterface, this.fixtureBean).firstName("a").simpleAccept();
        ((SenderFixtureInterface)Mockito.verify((Object)this.fixtureInterface)).accept(this.fixtureBean);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setFirstName("a");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }

    @Test
    public void testFullSender() {
        FixtureBeanAccepterImpl sender = new FixtureBeanAccepterImpl(this.fixtureInterface, this.fixtureBean);
        sender.children(this.list).age(5).accept();
        ((SenderFixtureInterface)Mockito.verify((Object)this.fixtureInterface)).accept(this.fixtureBean);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setAge(5);
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setChildren(this.list);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }

    @Test
    public void testConstructorSender() {
        SenderFixtureClass fixtureClass = new FixtureBeanSender(this.fixtureBean).firstName("f").lastName("a").send();
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setFirstName("f");
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setLastName("a");
        Assert.assertEquals((Object)fixtureClass.fixtureBean, (Object)this.fixtureBean);
    }

    @Test
    public void testStaticMethodSender() {
        FixtureBeanLocator locator = new FixtureBeanLocator("1", this.fixtureBean);
        Assert.assertEquals((String)locator.age(5).locate(), (String)"1");
        ((FixtureBean)Mockito.verify((Object)this.fixtureBean)).setAge(5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fixtureBean});
    }
}

