/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.parameters;

import fluent.api.generator.GenericImmutableFixture;
import fluent.api.generator.TestBase;
import fluent.api.generator.impl.GenericImmutableFixtureBuilderImpl;
import fluent.api.generator.parameters.GenericFixtureInterface;
import fluent.api.generator.parameters.GenericFixtureInterfaceInvoker;
import fluent.api.generator.parameters.ParametersFixtureClass;
import fluent.api.generator.parameters.ParametersFixtureClassSimpleBuilder;
import fluent.api.generator.parameters.ParametersFixtureClassSimpleCaller;
import fluent.api.generator.parameters.ParametersFixtureInterface;
import fluent.api.generator.parameters.ParametersFixtureInterfaceCalculator;
import fluent.api.generator.parameters.ParametersFixtureInterfaceCaller;
import fluent.api.generator.parameters.ParametersFixtureInterfaceCreator;
import fluent.api.generator.parameters.simple.ParametersFixtureClassCreator;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleParametersBuilderTest
extends TestBase {
    @Mock
    private ParametersFixtureInterface parametersFixtureInterface;
    @Mock
    private List<Double> list;
    @Mock
    private GenericFixtureInterface<String> genericFixtureInterface;
    private final ZonedDateTime zonedDateTime = LocalDateTime.now().atZone(ZoneId.systemDefault());

    @Test
    public void testSimpleInstanceMethodCaller() {
        LocalDateTime time = LocalDateTime.now();
        new ParametersFixtureInterfaceCaller(this.parametersFixtureInterface).anInt(5).aString("value").aTime(time).aList(this.list).call();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testSimpleInstanceMethodCalculator() {
        Mockito.when((Object)this.parametersFixtureInterface.calculate(5, "value", null, null)).thenReturn((Object)6);
        ParametersFixtureInterfaceCalculator calculator = new ParametersFixtureInterfaceCalculator(this.parametersFixtureInterface);
        Assert.assertEquals((int)calculator.anInt(5).aString("value").calculate(), (int)6);
    }

    @Test
    public void testSimpleInstanceMethodCreator() {
        Mockito.when((Object)this.parametersFixtureInterface.create(5, "value", null, null)).thenReturn((Object)this.zonedDateTime);
        Assert.assertEquals((Object)ParametersFixtureInterfaceCreator.fixtureInterface(this.parametersFixtureInterface).anInt(5).aString("value").create(), (Object)this.zonedDateTime);
    }

    @Test
    public void testSimpleStaticMethodCaller() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        new ParametersFixtureClassSimpleCaller().anInt(5).aString("value").aTime(time).aList(this.list).call();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testSimpleConstructorBuilder() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        ParametersFixtureClass fixtureClass = new ParametersFixtureClassSimpleBuilder().anInt(5).aString("value").aTime(time).aList(this.list).simpleBuild();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testSimpleStaticMethodCreator() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        Assert.assertEquals((Object)ParametersFixtureClassCreator.fixtureClass().anInt(5).aString("value").aTime(time).aList(this.list).create(), (Object)5);
    }

    @Test
    void testGenericParameterBuilder() {
        new GenericFixtureInterfaceInvoker<String>(this.genericFixtureInterface).input("Aha").invoke();
        ((GenericFixtureInterface)Mockito.verify(this.genericFixtureInterface)).myGenericMethod("Aha", null, 0, null, null);
    }

    @Test
    void testGenericConstructorParmateresBuilder() {
        GenericImmutableFixtureBuilderImpl builder = new GenericImmutableFixtureBuilderImpl();
        GenericImmutableFixture<Integer, String> result = builder.t(5).u(Collections.singletonList("Ua")).build();
        Assert.assertEquals(result.t, (Object)5);
        Assert.assertEquals(result.u, Collections.singletonList("Ua"));
    }
}

