/*
 * Decompiled with CFR 0.152.
 */
package fluent.api.generator.parameters;

import fluent.api.generator.TestBase;
import fluent.api.generator.parameters.ParametersFixtureClass;
import fluent.api.generator.parameters.ParametersFixtureInterface;
import fluent.api.generator.parameters.full.impl.ParametersFixtureInterfaceCreatorImpl;
import fluent.api.generator.parameters.impl.ParametersFixtureClassBuilderImpl;
import fluent.api.generator.parameters.impl.ParametersFixtureClassCallerImpl;
import fluent.api.generator.parameters.impl.ParametersFixtureClassCreatorImpl;
import fluent.api.generator.parameters.impl.ParametersFixtureInterfaceFullCalculatorImpl;
import fluent.api.generator.parameters.impl.ParametersFixtureInterfaceFullCallerImpl;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FullParametersBuilderTest
extends TestBase {
    @Mock
    private ParametersFixtureInterface parametersFixtureInterface;
    @Mock
    private List<Double> list;
    private final ZonedDateTime zonedDateTime = LocalDateTime.now().atZone(ZoneId.systemDefault());

    @Test
    public void testFullInstanceMethodCaller() {
        LocalDateTime time = LocalDateTime.now();
        ParametersFixtureInterfaceFullCallerImpl caller = new ParametersFixtureInterfaceFullCallerImpl(this.parametersFixtureInterface);
        caller.anInt(5).aString("value").aTime(time).aList(this.list).fullCall();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testFullInstanceMethodCalculator() {
        Mockito.when((Object)this.parametersFixtureInterface.calculate(5, "value", null, null)).thenReturn((Object)6);
        ParametersFixtureInterfaceFullCalculatorImpl calculator = new ParametersFixtureInterfaceFullCalculatorImpl(this.parametersFixtureInterface);
        Assert.assertEquals((int)calculator.anInt(5).aString("value").calculate(), (int)6);
    }

    @Test
    public void testFullInstanceMethodCreator() {
        Mockito.when((Object)this.parametersFixtureInterface.create(5, "value", null, null)).thenReturn((Object)this.zonedDateTime);
        ParametersFixtureInterfaceCreatorImpl calculator = new ParametersFixtureInterfaceCreatorImpl(this.parametersFixtureInterface);
        Assert.assertEquals((Object)calculator.anInt(5).aString("value").create(), (Object)this.zonedDateTime);
    }

    @Test
    public void testFullStaticMethodCaller() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        ParametersFixtureClassCallerImpl caller = new ParametersFixtureClassCallerImpl();
        caller.anInt(5).aString("value").aTime(time).aList(this.list).call();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testFullConstructorBuilder() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        ParametersFixtureClassBuilderImpl builder = new ParametersFixtureClassBuilderImpl();
        ParametersFixtureClass fixtureClass = builder.anInt(5).aString("value").aTime(time).aList(this.list).build();
        ((ParametersFixtureInterface)Mockito.verify((Object)this.parametersFixtureInterface)).call(5, "value", time, this.list);
    }

    @Test
    public void testFullStaticMethodCreator() {
        ParametersFixtureClass.fixtureInterface = this.parametersFixtureInterface;
        LocalDateTime time = LocalDateTime.now();
        ParametersFixtureClassCreatorImpl creator = new ParametersFixtureClassCreatorImpl();
        Assert.assertEquals((Object)creator.anInt(5).aString("value").aTime(time).aList(this.list).create(), (Object)5);
    }
}

